# GNU Enterprise Forms - GTK UI Driver - Toolbar widget
#
# Copyright 2001-2005 Free Software Foundation
#
# This file is part of GNU Enterprise
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: ToolBar.py 7008 2005-02-11 17:03:06Z reinhard $

import gtk

from gnue.common.apps import i18n
from gnue.forms.uidrivers._commonGuiToolkit.ToolBar import ToolBar as Base
  
# =============================================================================
# This class implements the toolbar for GTK2
# =============================================================================

class ToolBar (Base):

  # ---------------------------------------------------------------------------
  # Create the toolbar
  # ---------------------------------------------------------------------------

  def init (self):
    handlebox = gtk.HandleBox ()
    self.toolbar = gtk.Toolbar ()

    self.toolbar.set_orientation (gtk.ORIENTATION_HORIZONTAL)
    self.toolbar.set_style (gtk.TOOLBAR_ICONS)
    self.toolbar.set_tooltips (gtk.TRUE)
    handlebox.add (self.toolbar)
    
    self.container.content_table.attach (handlebox,
                                        # X direction           Y direction
                                        0, 1,                      1, 2,
                                        gtk.EXPAND | gtk.FILL,     0,
                                        0,                         0)
    self.toolbar.show ()
    handlebox.show ()

    self._useNewGTKAPI = gtk.pygtk_version >= (2, 4, 0)
    if self._useNewGTKAPI:
      # If we're using the new Toolbar-API turn off 'Overflow menus' and create
      # a new tootip group
      self.toolbar.set_show_arrow (False)
      self.tooltips = gtk.Tooltips ()

    return handlebox


  # ---------------------------------------------------------------------------
  # Add a menu item (action)
  # ---------------------------------------------------------------------------

  def addAction (self, name, userAction):

    gDebug (6, "TOOL: add action %s, %s" % \
        (repr (name), repr (userAction.description)))

    label   = name
    toolTip = userAction.description
    iconloc = userAction.getIconLocation (size = "24x24")

    # Set the action icon if available
    if not iconloc:
      gDebug (1, "Cannot add '%s' to toolbar; no icon" % userAction.event)
      return

    icon = gtk.Image ()
    icon.set_from_file (iconloc)

    # Create PyGTK 2.4.* style buttons
    if self._useNewGTKAPI:
      if userAction.canToggle:
        button = gtk.ToggleToolButton ()
        button.connect ('toggled', self._toggleEvent, userAction)
      else:
        button = gtk.ToolButton ()
        button.connect ('clicked', self._buttonPress, userAction)

      button.set_icon_widget (icon)
      button.set_label (label)
      button.set_tooltip (self.tooltips, toolTip, None)

      self.toolbar.insert (button, -1)
      
    # just stick with PyGTK 2.2.*
    else:
      if userAction.canToggle:
        button = self.toolbar.append_element (gtk.TOOLBAR_CHILD_TOGGLEBUTTON,
            None, label, toolTip, None, icon, self._toggleEvent, userAction)
      else:
        button = self.toolbar.append_item (label, toolTip, None, icon,
                                           self._buttonPress, userAction)
        
    return button


  # ---------------------------------------------------------------------------
  # Event handler for toggle buttons
  # ---------------------------------------------------------------------------

  def _toggleEvent (self, button, userAction):

    if button.get_active ():
      event = 'request%s' % userAction.event
    else:
      event = 'request%s' % userAction.canToggle

    self.driver.dispatchEvent (event, _form = self.form)


  # ---------------------------------------------------------------------------
  # Event handler for toolbar buttons
  # ---------------------------------------------------------------------------

  def _buttonPress (self, button, userAction):

    event = 'request%s' % userAction.event
    self.driver.dispatchEvent (event, _form = self.form)


  # ---------------------------------------------------------------------------
  # Add a separator
  # ---------------------------------------------------------------------------

  def addSeparator (self):

    if self._useNewGTKAPI:
      sep = gtk.SeparatorToolItem ()
      self.toolbar.insert (sep, -1)
    else:
      self.toolbar.append_space ()
    

  # ---------------------------------------------------------------------------
  # Enable a menu item
  # ---------------------------------------------------------------------------

  def enableItem (self, item):
    if item is not None:
      item.set_sensitive (1)
  

  # ---------------------------------------------------------------------------
  # Disable a menu item
  # ---------------------------------------------------------------------------

  def disableItem (self, item):
    if item is not None:
      item.set_sensitive (0)
  

  # ---------------------------------------------------------------------------
  # Set an item active
  # ---------------------------------------------------------------------------

  def startingItem (self, item):
    if item is not None:
      item.set_active (1)

  # ---------------------------------------------------------------------------
  # Set an item inactive
  # ---------------------------------------------------------------------------

  def endingItem (self, item):
    if item is not None:
      item.set_active (0)
