# GNU Enterprise Forms - Curses UI Driver - Button Widget
#
# Copyright 2000-2005 Free Software Foundation
#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: button.py 6851 2005-01-03 20:59:28Z jcater $

import curses

from _base import UIHelper

# =============================================================================
# Button class
# =============================================================================

class UIButton (UIHelper):

  # ---------------------------------------------------------------------------
  # Initialization
  # ---------------------------------------------------------------------------

  def __init__ (self, event):

    UIHelper.__init__ (self, event)

    # Determine button text
    maxlen = event.object ['Char:width'] - 2
    label = event.object.label [:maxlen]                # cut if too long
    label = ' ' * ((maxlen - len (label)) / 2) + label  # expand if too short
    label = label + ' ' * (maxlen - len (label))

    self.__text = '[' + label + ']'

  # ---------------------------------------------------------------------------
  # Initialization per row
  # ---------------------------------------------------------------------------

  def _init (self, index):

    self.__repaint (index)

  # ---------------------------------------------------------------------------
  # Focus has changed to this button
  # ---------------------------------------------------------------------------

  def _getFocus (self, index):

    self.__repaint (index)

  # ---------------------------------------------------------------------------
  # Focus has changed away from this button
  # ---------------------------------------------------------------------------

  def _loseFocus (self, index):

    self.__repaint (index)

  # ---------------------------------------------------------------------------
  # Update button representation on screen
  # ---------------------------------------------------------------------------

  def __repaint (self, index):

    if index == self._focusIndex:
      attr = self._uiDriver.attr ['focusentry']
    else:
      attr = self._uiDriver.attr ['entry']

    self._setText (index, self.__text, attr)

# =============================================================================
# Configuration data
# =============================================================================

configuration = {
  'baseClass'  : UIButton,
  'provides'   : 'GFButton',
  'container'  : 0,
  }
