# GNU Enterprise Forms - Curses UI Driver - Widget Base
#
# Copyright 2000-2005 Free Software Foundation
#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: _base.py 6851 2005-01-03 20:59:28Z jcater $

import curses

from gnue.forms.uidrivers._base.widgets._base import UIWidget

# =============================================================================
# Widget helper class
# =============================================================================

class UIHelper (UIWidget):

  # ---------------------------------------------------------------------------
  # Initialize
  # ---------------------------------------------------------------------------

  def __init__ (self, event):

    UIWidget.__init__ (self, event)

    # should go in base uidriver
    self._parent = event.parent
    self._focusIndex = None
    self._x = self._gfObject ['Char:x']
    self._y = self._gfObject ['Char:y']

    # curses specific
    self.__cursor = (0, 0)

  # ---------------------------------------------------------------------------
  # Initialize widget
  # ---------------------------------------------------------------------------

  def createWidget (self, event, spacer):

    # should go in base uidriver
    self._init (spacer)

  # ---------------------------------------------------------------------------
  # Set focus to widget
  # ---------------------------------------------------------------------------

  def indexedFocus (self, index):

    # should go in base uidriver
    self._focusIndex = index
    self._getFocus (index)

    # curses specific
    self.__updateCursorPosition ()

  # ---------------------------------------------------------------------------
  # Remove focus from widget
  # ---------------------------------------------------------------------------

  def loseFocus (self):

    # should go in base uidriver
    index = self._focusIndex
    self._focusIndex = None
    self._loseFocus (index)

  # ---------------------------------------------------------------------------
  # Set text for widget
  # ---------------------------------------------------------------------------

  def _setText (self, index, text, attr, selection = None):

    if selection:
      (s1, s2) = selection
      self._parent.write (self._x, self._y + index, text[:s1], attr)
      self._parent.write (self._x + s1, self._y + index, text[s1:s2],
                          attr + curses.A_STANDOUT)
      self._parent.write (self._x + s2, self._y + index, text[s2:], attr)
    else:
      self._parent.write (self._x, self._y + index, text, attr)

  # ---------------------------------------------------------------------------
  # Set cursor position for widget
  # ---------------------------------------------------------------------------

  def _setCursor (self, x, y):

    self.__cursor = (x, y)
    self.__updateCursorPosition ()

  # ---------------------------------------------------------------------------
  # Update cursor position
  # ---------------------------------------------------------------------------

  def __updateCursorPosition (self):

    if self._focusIndex is not None:
      (x, y) = self.__cursor
      self._parent.move (self._x + x, self._y + self._focusIndex + y)
