#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Founda      tion; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2005 Free Software Foundation
#
# FILE:
# UIWidget.py
#
# DESCRIPTION:
# A generic class that handles most the internals of widget management in
# gnue forms.  This should be subclassed by each of the specific driver's
# widgets.
#
# NOTES:
#


#TODO: don't forget to cvs remove the old UIWidgets from base

import string
from gnue.common import events
from gnue.common.apps import GDebug
from gnue.common.definitions.GObjects import GObj
from gnue.forms.GFKeyMapper import KeyMapper

class UIWidget(GObj):
  def __init__(self, event):
    GObj.__init__(self, parent=event.parent)
    #
    # set the default _type based upon the UIclass it is
    #
    self._type = string.split("%s" % self.__class__,'.')[-1]

    self._inits=[self.primaryInit]

    #TODO: Patented MemorySucka 2000 technology
    self._creationEvent = event

    self._containerToolkitWidget = None  # If this widget can contain other
                                         # widgets then this the the toolkit
                                         # specific container children should use

    self._gfObject = event.object

    self.widgets = []

    #TODO: shouldn't the _gfObject checks be done in the gfObjects?
    if not hasattr(self._gfObject,'_rows'):
      self._gfObject._rows = 1

    if not hasattr(self._gfObject,'_gap'):
      self._gfObject._gap = 0

    if hasattr(self._gfObject,'Char__width'):
      self.itemWidth = self._gfObject.Char__width*int(event.textWidth)
    else:
      self.itemWidth = -1

    if hasattr(self._gfObject,'Char__height'):
      self.itemHeight = self._gfObject.Char__height*int(event.textHeight)
    else:
      self.itemHeight = -1

    if hasattr(self._gfObject,'Char__x'):
      self.itemX = self._gfObject.Char__x*int(event.widgetWidth)
    else:
      self.itemX = -1

  #
  # primaryInit
  #
  # The initial phased init run
  #
  def primaryInit(self):
    self._uiDriver = self.findParentOfType('UIDriver')
    self._uiForm = self.findParentOfType('UIForm')

    try:
      self._creationEvent.container = self._parent._containerToolkitWidget
    except AttributeError:


      if not hasattr(self._creationEvent, 'container'):
        self._creationEvent.container = None

    #print "The container will be ",self._creationEvent.container
    if not self._gfObject.hidden:
      for spacer in range(int(self._gfObject._rows)):
        newWidget = self.createWidget(self._creationEvent, spacer)
        self.widgets.append(newWidget)

      GDebug.printMesg (5, "WIDGETS.APPEND: %s, %s (%s)" % \
            (self._gfObject.name, self, self.widgets))


  #
  # Helper functions for descendants
  #
  # fire a requestXXX event
  def _request (self, name, **params):
    params ['_object'] = self._gfObject
    params ['_form'] = self._gfObject._form
    self._uiDriver.dispatchEvent (events.Event ("request%s" % name, **params))

  # Handle a keyboard request for a character key
  def _keypress (self, character):
    if character in [chr (9), chr (10)]: # tab and enter shouldn't be ctrl keys
      self._request (KeyMapper.getEvent (ord (character), False, False, False))
    elif character < ' ':                # control key
      self._request (KeyMapper.getEvent (ord (character) + 96,
                                         False, True, False))
    else:
      self._request ('KEYPRESS', text = character)

  # Handle a keyboard request for a function key
  def _fkeypress (self, key, shift, ctrl, meta):
    self._request (KeyMapper.getEvent (key, shift, ctrl, meta))


  #
  # The following functions should be overridden by the widgets
  # in the ui driver.
  #
  def createWidget(self, event, spacer):
    GDebug.printMesg(1,"UI doesn't support %s" % self.__class__)

  def indexedFocus(self, index):
    pass

  def loseFocus(self):
    pass

  def showModal(self):
    pass

  def destroy(self):
    pass

  def setValue(self, value, index=0, enabled=1):
    pass

  def setCursorPosition(self, position, index=0):
    pass

  def setSelectedArea(self, selection1, selection2, index=0):
    pass


