#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2005 Free Software Foundation
#
# FILE:
# GFObjects.py
#
# DESCRIPTION:
"""
Logical button support
"""
# NOTES:
#
from GFTabStop import GFTabStop

#
# GFButton
#
class GFButton(GFTabStop):
  def __init__(self, parent=None):
    GFTabStop.__init__(self, parent, 'GFButton')
    self.label = ""
    self._inits = [self.initialize]
    self._navigable = True
    self._validTriggers ={ 'ON-ACTION':      'On-Action',
                           'PRE-FOCUSOUT':   'Pre-FocusOut',
                           'POST-FOCUSOUT':  'Post-FocusOut',
                           'PRE-FOCUSIN':    'Pre-FocusIn',
                           'POST-FOCUSIN':   'Post-FocusIn'}


  def initialize(self):
    self._page = self.findParentOfType('GFPage')
    self._form = self.findParentOfType('GFForm')
    self._page._entryList.append(self)
    self._navigable = self.navigable

    listeners = {
      'requestKEYPRESS': self.__handleKEYPRESS,
      'requestENTER':    self.__handleENTER
    }
    self.subEventHandler.registerEventListeners(listeners)

  def isNavigable(self, mode):
    # Buttons aren't navigable during queries
    if mode == 'query':
      return False
    else:
      return GFTabStop.isNavigable(self, mode)


  # Helper method for user events: fire button
  def __fire(self):
    self.processTrigger('On-Action', False)


  # Event handlers

  def __handleKEYPRESS(self, event):
    if event.text == ' ':
      self.__fire()
      event.drop()

  def __handleENTER(self, event):
    self.__fire()
    event.drop()
