/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2004 The GFC Development Team.
 *
 *  toggleactionsignals.cc - Gtk::ToggleAction virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "toggleaction.hh"
#include "toggleactionsignals.hh"
#include "private/toggleactionclass.hh"

using namespace GFC;

/*  Gtk::ToggleActionSignals
 */

Gtk::ToggleActionSignals::ToggleActionSignals(ToggleAction *action)
: ActionSignals(action)
{
	Gtk::ToggleActionClass::init(GTK_TOGGLE_ACTION_GET_CLASS(action->gtk_toggle_action()));
}

Gtk::ToggleActionSignals::~ToggleActionSignals()
{
}

void
Gtk::ToggleActionSignals::on_toggled()
{
	GtkToggleActionClass *g_class = ToggleActionClass::get_parent_class(instance_);
	if (g_class->toggled)
		g_class->toggled((GtkToggleAction*)instance_);
}

/*  Gtk::ToggleActionClass
 */

void
Gtk::ToggleActionClass::init(GtkToggleActionClass *g_class)
{
	g_class->toggled = &toggled_proxy;
}

GtkToggleActionClass*
Gtk::ToggleActionClass::get_parent_class(void *instance)
{
	void *ptr = g_type_class_peek_parent(GTK_TOGGLE_ACTION_GET_CLASS(instance));
	return static_cast<GtkToggleActionClass*>(ptr);
}

GType
Gtk::ToggleActionClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_TOGGLE_ACTION);
	}
	return type;
}

void*
Gtk::ToggleActionClass::create(const char *name)
{
	return g_object_new(get_type(), "name", name, 0);
}

void
Gtk::ToggleActionClass::toggled_proxy(GtkToggleAction *action)
{
	void *ptr = g_object_get_qdata((GObject*)action, G::ObjectSignals::quark());
	if (ptr)
		static_cast<ToggleActionSignals*>(ptr)->on_toggled();
	else
	{
		GtkToggleActionClass *g_class = ToggleActionClass::get_parent_class(action);
		if (g_class->toggled)
			g_class->toggled(action);
	}
}

