static char rcsid[] = "$Id: res_ascfile.c,v 1.1 1997/05/29 08:45:29 dhb Exp $";

/* Version EDS17, Erik De Schutter, Caltech 1991 */

/*
** $Log: res_ascfile.c,v $
** Revision 1.1  1997/05/29 08:45:29  dhb
** Initial revision
**
** Revision 1.1  1997/05/29 08:45:29  dhb
** Initial revision
**
*/

#include "out_ext.h"

ResAscFileOutput(output,action)
struct res_ascfile_type *output;
Action		*action;
{
MsgIn	*msg;

    switch(action->type){
    case RESET:
		/* set the initialization flag */
		if(!output->append){
			output->initialize = TRUE;
		}
		/* force output of first value */
		if (output->time_res>0) {
			output->last_time=-2*output->time_res;
		} else {
			output->last_time=-1000;
		}
		output->nvalues=0;
		MSGLOOP(output,msg){
		case 0:
			output->nvalues++;
			break;
		}
		if (output->nvalues>100)
		   ErrorMessage("Res_ascfile", "Too many SAVE msgs.",output);
		if (output->last_values) free(output->last_values);
		output->last_values=(float *)calloc(output->nvalues,sizeof(float));
		break;
    case PROCESS:
		/* has the file been initialized? */
		if(output->initialize){
			AscSetupFile(output);
		}
		/* open the file and append data to it */
		if(OpenOutputFile(output,"a")){
			ResAscWriteOutput(output);
			ConditionalCloseOutputFile(output);
		}
		break;
	case CHECK:
		if ((output->time_res<=0)||(output->value_res<=0)) 
		   ErrorMessage("Res_ascfile", "time_res or value_res not set.",output);
		break;
    case DELETE:
    case SAVE:
		CloseOutputFile(output);
		break;
    default:
		InvalidAction("FileOutput",output,action);
		break;
    }
}

ResAscWriteOutput(output)
struct res_ascfile_type *output;
{
FILE *fp;
MsgIn	*msg;
float	fval;
float	cur_values[100];
int		i;
short	do_it;

	do_it=0;
	i=0;
    MSGLOOP(output,msg){
	case 0:
	    fval = MsgValue(msg,float,0);
		if (((SimulationTime()-output->last_time)>output->time_res) ||
		    (fabs(fval-output->last_values[i])>output->value_res))
/*printf("time:%d %f  %f\n",i,SimulationTime()-output->last_time,output->time_res);
printf("val:%d %f  %f\n",i,fabs(fval-output->last_values[i])>output->value_res);*/
			do_it=1;
		cur_values[i]=fval;
		i++;
	    break;
    }
	if (do_it) {
		output->last_time=(float )SimulationTime();
		fp = output->fp;
		fprintf(fp,"%g ",simulation_time);
		for (i=0; i<output->nvalues; i++) {
			fprintf(fp,"%g ",cur_values[i]);
			output->last_values[i]=cur_values[i];
		}
		fprintf(fp,"\n");
		/* force it to disk if actioned */
		if(output->flush)
			fflush(fp);
	}
}

