#ifndef CKJTHREAD_H
#define CKJTHREAD_H

#include <sigc++/class_slot.h>
#include <glibmm/thread.h>


/**	a wrapper class for Glib::Thread to use a Glib::Thread like a java or commonc++2
 *	object. simply derive your own class, overwrite run() and implement the behaviour
 *	of your own thread object.
 *	as this class cannot be derived from Glib::Thread (because a Glib::Thread object
 *	can only be instantiated with the static Thread::create() method),
 *	operators are offered to access the actual Glib::Thread object.
 *	@author triendl.kj
 */
class CkjThread
{
	Glib::Thread* m_pThread;
	bool m_bJoinable;
	

public:
	CkjThread(bool bJoinable = false);


private:
	/**	a wrapper method for the actual run to realize when the thread has stopped
	 */
	void _run();
	
protected:
	/**	overwrite this method in your derived class
	 */
	virtual void run() = 0;

public:
	/**	starts the thread.
	 *	@param bool start the thread joinable or not, overwrites what you have
	 *	specified in the constructor
	 */
	void start(bool bJoinable);
	
	/**	starts the thread. uses the information whether it is joinable or not provided
	 *	in the constructor.
	 */
	void start()
	{
		start(m_bJoinable);
	}
	
	bool isRunning() const
	{
		return (m_pThread != NULL);			
	}
	
	Glib::Thread* operator ->()
	{
		return m_pThread;
	}
	
	const Glib::Thread* operator ->() const
	{
		return m_pThread;
	}
	
	Glib::Thread& operator *()
	{
		return *m_pThread;
	}
	
	const Glib::Thread& operator *() const
	{
		return *m_pThread;
	}

	operator Glib::Thread*() const
	{
		return m_pThread;
	}

	operator const Glib::Thread*() const
	{
		return m_pThread;
	}
	
	operator Glib::Thread&() const
	{
		return *m_pThread;
	}
	
	operator const Glib::Thread&() const
	{
		return *m_pThread;
	}
};

#endif
