#    This file is part of the FElt finite element analysis package.
#    Copyright (C) 1993-1996 Jason I. Gobat and Darren C. Atkinson
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

# Makefile for manual pages
# MANS names the manual pages
# SECTION names the section directory

.SUFFIXES: .1 .3 .4 .dvi .ps

include $(TOPDIR)/etc/Makefile.conf

all::;

clean::;

clobber::;

install::;	@$(MKDIR) $(DESTMAN)/$(SECTION)
		@for f in $(MANS); do \
		$(INSTALL) -m 0644 $$f $(DESTMAN)/$(SECTION); done

depend::;

.1.dvi::;	groff -man -Tdvi $< > $@
.3.dvi::;	groff -man -Tdvi $< > $@
.4.dvi::;	groff -man -Tdvi $< > $@
.dvi.ps::;	dvips $< -o $@
