;;;; -*- Mode: LISP; Syntax: ANSI-Common-Lisp; Package: rsm.bool-comp.test -*-
;;;; *************************************************************************
;;;; FILE IDENTIFICATION
;;;;
;;;; Name:          bool-comp-test.lisp
;;;; Purpose:       Regression Testing For Boolean Comparison Package.
;;;; Author:        R. Scott McIntire
;;;; Date Started:  Aug 2003
;;;;
;;;; $Id: bool-comp-test.lisp,v 1.2 2003/09/10 22:19:24 rscottmcintire Exp $
;;;; *************************************************************************

(in-package #:cl-user)

(defpackage rsm.bool-comp.test
  (:use #:cl rsm.bool-comp #:ptester)
  (:documentation
   "Provides a test harness for boolean logic.")
  )


(in-package rsm.bool-comp.test)


(defun run-bool-comp-tests ()

  (with-tests (:name "Boolean-Compare")
    (test nil
          (convert-tree->xor 
           '(^ (+ (* (~ #(1 2)) #(2 1))
                (* (~ #(2 1)) #(1 2)))
             (* (+ #(1 2) #(2 1))
              (+ (~ #(1 2)) (~ #(2 1))))) 2)
          :fail-info "Test 1")
    
    (test '(#(1 1) #(2 1))
          (convert-tree->xor '(^ (^ #(2 1) #(1 2)) (^ #(1 2) #(1 1))) 2)
          :test #'equalp
          :fail-info "Test 2")

    (test '(#(0 2 1) #(1 1 2) #(1 0 1))
          (convert-tree->xor '(+ #(1 1 2) #(0 2 1) (* #(1 2 1) #(2 0 2))) 3)
          :test #'equalp
          :fail-info "Test 3")

    (test '(#(2 0 2) #(1 1 2) #(0 1 1))
          (rsm.bool-comp::orthog '(#(2 0 2) #(1 1 2) #(0 2 1)) 3)
          :test #'equalp
          :fail-info "test4")
    
    (test nil
          (is-function-non-zero? '(#(1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2) #(1 0 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2) #(1 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2) #(2 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2) #(0 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2) #(1 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2) #(2 2 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2) #(0 2 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2) #(1 2 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2)) 32)
          :fail-info "Test 5")
    
    (test nil
          (is-function-non-zero? '(#(1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2) #(1 0 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2) #(1 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2) #(2 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2) #(0 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2) #(1 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2) #(2 2 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2) #(0 2 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2) #(1 2 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2)) 32)
          :fail-info "Test 6")

    (test #(0 1 1 0 0 0 0 0 0 0 0 1 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0)
          (is-function-non-zero? '(#(1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2) #(1 0 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2) #(1 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2) #(2 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2) #(0 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2) #(1 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2) #(2 2 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2) #(0 2 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2) #(1 2 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 1 2 2 2 2) #(1 2 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 1 2 0 2 2 2 2) #(1 2 1 2 2 2 2 2 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 0 2 0 2 2 2 2) #(1 2 1 2 2 2 2 2 0 2 2 2 2 1 2 2 2 2 2 2 2 2 2 2 2 0 2 0 2 2 2 2) #(1 2 1 2 0 2 2 2 0 2 2 2 2 0 2 2 2 2 2 2 2 2 2 2 2 0 2 0 2 2 2 2) #(1 2 1 2 1 2 2 2 0 2 2 2 2 0 2 2 2 2 2 2 2 2 2 2 2 0 2 0 2 2 2 2) #(0 2 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 1 2) #(0 2 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 1) #(0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1) #(0 1 1 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 1 0) #(0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 1 0) #(0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 1 0) #(0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 1 0) #(0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 1 0) #(0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 0) #(0 1 1 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 1 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 1 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 1 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 1 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 1 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 1 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 1 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 1 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 1 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 0 1 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 1 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 1 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 1 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 0 1 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 0 0 1 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 1 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 1 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 1 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 0 1 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 0 0 1 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 0 0 0 1 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 1 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 1 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 0 1 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 0 0 1 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 0 0 0 1 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 0 0 0 0 1 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 1 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 1 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 1 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 0 0 1 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 0 0 0 1 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 0 0 0 0 1 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 0 0 0 0 0 1 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 1 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 1 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 1 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 0 1 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 0 0 0 1 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 0 0 0 0 1 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 0 0 0 0 0 1 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 0 0 0 0 0 0 1 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 1 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 1 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 1 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 0 1 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 0 0 1 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 0 0 0 0 1 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 0 0 0 0 0 1 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 0 0 0 0 0 0 1 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 0 0 0 0 0 0 0 1 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 1 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 1 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 1 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 0 1 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 0 0 1 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 0 0 0 1 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0) #(0 1 1 0 0 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0)) 32)
          :test #'equalp
          :fail-info "Test 7")
    
    (test #(1 0 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
          (is-function-non-zero? '(#(1 2 2 2 2 2 2 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2) #(1 0 2 2 2 2 2 2 2 2 2 2 2 0 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2) #(1 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2) #(2 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2) #(0 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2) #(1 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2) #(2 2 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2) #(0 2 1 2 2 2 2 2 2 2 2 2 2 0 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2) #(1 2 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 1 2 2 2 2 2 2 2 2) #(0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1) #(0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)) 32)
          :test #'equalp
          :fail-info "Test 8")

    (test #(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
          (is-function-non-zero? '(#(1 2 2 2 2 2 2 1 2 2 2 2 2 2 0 1 0 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2) #(1 0 2 2 2 2 2 2 2 2 2 2 2 0 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2) #(1 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2) #(2 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2) #(0 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 1 1 0 0 2 2 2 2 2 2 2 2) #(1 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2) #(2 2 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2) #(0 2 1 2 2 2 2 2 2 2 2 2 2 0 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2) #(1 2 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 1 2 2 2 2 2 2 2 2) #(0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1) #(0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1) #(0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)) 32)
          :test #'equalp
          :fail-info "Test 9")

    (test #(1 1 1 1 1 0 1 1 1 1)
          (is-function-non-zero? '(#(2 1 2 1 2 2 1 1 0 2) #(1 1 2 1 2 0 1 1 2 2) #(0 2 1 1 1 2 2 1 1 1) #(0 0 1 1 1 1 1 1 1 1) #(0 1 1 1 1 1 1 1 1 1)) 10)
          :test #'equalp
          :fail-info "Test 10")

    (test nil
          (is-function-non-zero? '(#(2 2 0 1 1 0) #(2 1 0 0 1 0) #(2 0 0 0 1 0) #(1 2 0 2 1 0) #(0 0 0 2 1 0) #(0 1 0 2 1 0)) 6)
          :fail-info "Test 11")

    (test #(1 0 1 1 1 1 1 1)
          (is-function-non-zero? '(#(1 2 0 1 2 1 2 1 2 2) #(2 2 2 1 0 2 1 0 2 2) #(1 1 2 1 2 1 0 0 2 2) #(2 1 2 1 2 1 2 1 2 2) #(1 2 1 2 1 2 1 2 2 2) #(0 1 1 1 1 1 1 1 2 2)) 8)
          :test #'equalp
          :fail-info "Test 12")

    (test #(0 1 1 1 0 1 0 1 0 0 0 0 1 1 0 0 1 1 1 0)
          (is-function-non-zero? '(#(1 2 0 1 2 1 2 1 2 2 1 0 1 1 0 1 2 2 1 1) #(2 2 2 1 0 2 1 0 2 2 1 2 2 2 0 0 2 2 2 0) #(1 1 2 1 2 1 0 0 2 2 0 1 0 0 1 1 0 2 0 2) #(2 1 2 1 2 1 2 1 2 2 2 2 1 1 0 2 1 1 1 2) #(1 2 1 2 1 2 1 2 2 2 1 2 1 0 1 2 0 1 1 1) #(0 1 1 1 1 1 1 1 2 2 2 1 0 1 2 1 2 1 0 2) #(0 1 1 1 1 1 1 1 1 1 1 1 1 1 2 2 1 2 2 2) #(0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 2 2 0 0) #(0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)) 20)
          :test #'equalp
          :fail-info "Test 13")

    (test #(1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
          (is-function-non-zero? '(#(1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2) #(2 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2) #(2 2 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2) #(2 2 2 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2) #(2 2 2 2 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2) #(2 2 2 2 2 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2) #(2 2 2 2 2 2 1 2 2 2 2 2 2 2 2 2 2 2 2 2) #(2 2 2 2 2 2 2 2 1 2 2 2 2 2 2 2 2 2 2 2) #(2 2 2 2 2 2 2 2 2 2 1 2 2 2 2 2 2 2 2 2) #(2 2 2 2 2 2 2 2 2 2 2 1 2 2 2 2 2 2 2 2) #(2 2 2 2 2 2 2 2 2 2 2 2 2 2 1 2 2 2 2 2) #(2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 1 2 2 2 2) #(2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 1 2 2) #(2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 1) #(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1) #(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1) #(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1) #(0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1) #(0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1) #(0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1) #(0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1) #(0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1) #(0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1) #(1 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1) #(1 1 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1) #(1 1 1 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)) 20)
          :test #'equalp
          :fail-info "Test 14")

    (test #(0 1 0 1 1 1 1 1)
          (is-function-non-zero? '(#(2 1 2 2 2 2 2 2) #(1 2 2 2 2 2 2 2) #(1 2 2 2 2 2 2 2) #(1 1 2 2 2 2 2 2) #(0 1 1 1 1 1 1 1)) 8)
          :test #'equalp
          :fail-info "Test 15")

    (test #(0 0 0 1 1 1 1 1 1 1)
          (is-function-non-zero? (convert-tree->xor '(^ #(0 0 0 0 1 1 1 1 1 1) (+ #(1 2 1 2 1 2 1 2 1 2) #(2 1 2 1 2 1 2 1 2 1) (^ #(1 0 2 1 0 2 1 1 2 0) #(2 1 2 2 1 1 1 0 0 2) ) #(2 2 2 2 1 1 1 1 1 1) (^ #(2 1 1 1 1 2 0 0 2 2) #(0 0 1 1 2 2 1 1 0 0)) #(1 1 1 1 1 2 2 2 2 2))) 10) 10)
          :test #'equalp
          :fail-info "Test 16")

    (test #(1 1 1 1 1 1 1 1 1 1)
          (is-function-non-zero? '(#(0 1 1 1 1 1 1 1 1 1) #(0 0 1 1 1 1 1 1 1 1) #(0 0 0 1 1 1 1 1 1 1) #(0 0 0 0 1 1 1 1 1 1) #(0 0 1 1 2 2 1 1 0 0) #(0 0 2 2 1 1 1 1 1 1) #(0 1 2 0 1 1 1 1 1 1) #(0 1 2 1 2 1 2 1 2 1) #(1 0 2 1 0 2 1 1 2 0) #(1 1 0 1 2 1 2 1 2 1) #(1 1 1 1 0 1 2 1 2 1) #(1 1 1 1 1 0 0 0 2 2) #(1 1 1 1 1 0 0 2 2 2) #(1 1 1 1 1 1 0 1 2 1) #(1 1 1 1 1 1 1 1 0 1) #(1 2 1 2 1 2 1 2 1 2) #(2 1 2 2 1 1 1 0 0 2) #(2 1 1 1 1 2 0 0 2 2)) 10)
          :test #'equalp
          :fail-info "Test 17")
    
    (test #(1 1 0 1 1 1 1 1)
          (is-function-non-zero? '(#(1 2 2 2 2 2 2 2) #(1 0 2 2 2 2 2 2) #(1 1 2 2 2 2 2 2) #(2 1 2 2 2 2 2 2) #(0 1 2 2 2 2 2 2) #(1 1 2 2 2 2 0 1) #(2 2 1 2 2 2 2 2) #(0 2 1 2 1 1 2 2) #(1 2 1 0 2 2 2 1) #(1 0 1 1 1 1 2 1)) 8)
          :test #'equalp
          :fail-info "Test 18")

    (test #(1 0 1 1 1 1 1 1)
          (is-function-non-zero? '(#(1 2 2 2 1 0 2 2) #(1 0 2 2 2 2 2 2) #(1 1 2 2 2 2 2 2) #(2 1 1 2 2 2 0 2) #(0 1 2 2 2 2 2 2) #(1 1 2 2 2 2 0 1) #(2 2 1 2 2 2 2 2) #(0 2 1 2 1 1 2 2) #(1 2 1 0 2 2 2 1) #(1 0 1 1 1 1 2 1) #(1 0 1 0 1 1 2 0) #(0 1 1 1 1 1 1 1)) 8)
          :test #'equalp
          :fail-info "Test 19")

    (test #(1 1 0)
          (is-function-non-zero? '(#(1 2 2) #(1 0 1) #(1 1 1) #(1 0 0)) 3)
          :test #'equalp
          :fail-info "Test 20")

    (test #(1 0 1 1 1 1 1 1)
          (is-function-non-zero? '(#(1 2 0 2 1 0 2 2) #(1 0 2 2 2 2 1 2) #(1 1 2 2 2 2 2 2) #(2 1 1 2 2 2 0 2) #(0 1 2 2 2 2 2 2) #(1 1 2 2 2 2 0 1) #(2 2 1 2 2 2 2 2) #(0 2 1 2 1 1 2 2) #(1 2 1 0 2 2 2 1) #(1 0 1 1 1 1 2 1) #(1 0 1 0 1 1 2 0) #(0 1 1 1 1 1 1 1)) 8)
          :test #'equalp
          :fail-info "Test 21")

    (test #(1 1 1 1 1 1 1 1)
          (is-function-non-zero? '(#(1 0 1 0 1 2 1 0) #(0 1 1 0 1 2 0 1) #(0 1 1 0 1 1 1 1) #(1 0 1 0 1 1 1 1) #(1 0 1 0 1 0 1 1) #(0 0 1 1 1 1 1 1) #(0 0 0 1 1 1 1 1) #(0 0 0 0 0 0 0 1) #(0 0 0 0 0 0 0 0) #(0 1 2 0 2 1 2 1) #(2 1 2 0 2 0 2 0) #(0 2 1 0 1 2 1 2) #(1 2 0 2 1 0 2 1) #(2 1 0 2 1 0 1 2) #(1 2 1 0 2 1 2 0) #(0 2 0 1 2 0 2 0) #(1 2 1 0 2 1 2 0) #(0 2 0 2 1 0 1 2) #(2 1 2 0 1 2 0 2) #(1 0 2 0 2 0 2 1) #(2 0 2 1 0 2 0 1) #(0 1 2 0 2 0 2 1) #(1 0 2 0 2 1 0 1) #(0 2 1 2 0 2 1 2) #(2 1 2 0 1 2 0 2) #(0 1 0 1 2 0 1 0) #(0 2 0 1 0 2 1 0) #(1 0 1 0 1 0 1 0) #(0 2 1 0 1 2 1 0) #(2 1 2 0 2 0 1 2) #(0 2 0 1 0 1 2 0) #(1 0 1 2 1 2 0 1) #(2 0 1 2 1 2 0 1) #(1 0 1 0 1 0 1 0) #(0 2 1 0 1 2 0 1) #(1 2 0 2 0 2 1 0) #(2 1 2 0 2 0 2 0) #(2 1 0 1 0 2 1 2) #(1 2 1 0 2 1 2 1) #(0 2 0 1 2 0 1 0) #(2 1 0 1 0 2 1 2) #(1 2 1 0 1 2 0 2) #(0 2 0 1 2 1 0 2) #(2 0 2 0 1 0 1 2) #(0 2 1 0 2 1 0 2) #(2 1 0 1 2 0 1 0) #(2 1 0 1 2 0 2 1) #(2 1 2 1 0 1 0 2) #(1 2 1 0 1 2 0 2) #(0 1 0 1 0 2 1 2) #(1 2 1 2 1 2 1 2) #(2 1 0 2 1 2 0 1) #(2 1 2 1 2 0 2 1) #(2 0 1 0 2 1 2 0) #(1 0 1 2 1 0 2 0) #(1 0 2 0 1 2 0 1) #(0 1 2 1 2 1 0 1) #(0 1 0 2 0 2 1 0) #(1 2 0 1 2 1 0 2) #(0 2 0 1 2 1 0 1) #(2 1 2 1 0 2 0 2) #(1 2 1 2 0 2 1 0) #(2 1 0 1 2 0 2 1) #(0 1 2 1 0 2 0 1) #(1 2 0 2 1 2 0 2) #(2 1 2 0 1 0 2 0) #(0 1 0 2 0 1 2 0) #(0 2 0 1 2 1 2 0) #(0 2 0 2 1 2 0 1) #(0 2 0 1 2 1 2 1) #(1 0 2 1 0 1 2 0) #(2 1 0 2 0 1 2 1) #(2 0 1 2 1 2 1 2) #(0 2 1 2 1 2 0 1) #(0 2 0 2 0 1 0 1) #(1 0 1 2 0 1 2 0) #(0 1 0 2 1 0 1 2) #(0 2 1 2 1 2 0 1) #(1 2 0 1 2 0 2 1) #(2 0 1 0 1 0 1 0) #(0 2 1 0 1 2 0 2) #(2 1 0 1 2 1 2 1) #(2 1 2 0 2 0 2 0) #(0 2 1 2 1 2 1 2) #(2 0 2 0 1 0 1 0) #(2 1 0 1 2 0 1 0) #(2 0 1 0 1 2 0 2) #(2 1 2 1 0 1 0 1) #(0 2 0 2 0 2 0 2) #(0 2 1 0 2 1 0 1) #(1 2 1 0 2 1 0 1) #(0 2 1 0 1 0 1 2) #(2 1 0 1 2 1 0 1) #(0 2 1 0 1 0 2 0) #(1 2 1 0 2 0 2 0) #(2 0 2 1 2 0 1 0) #(0 2 0 1 2 1 2 0) #(1 2 1 0 2 1 2 0) #(1 2 0 2 1 0 2 0) #(0 1 2 0 2 0 1 0) #(1 2 0 1 0 2 0 2) #(0 2 0 2 0 1 0 2) #(0 2 1 2 0 1 0 1) #(1 2 1 2 1 2 0 2) #(2 1 2 1 0 1 2 1) #(2 0 1 0 1 0 2 1) #(0 2 1 2 1 2 1 2) #(0 2 1 0 1 2 1 2) #(0 1 2 0 1 2 1 2)) 8)
          :test #'equalp
          :fail-info "Test 22")
    
    (test #(1 0 1 0 1 1 1 1)
          (rsm.bool-comp::try-to-find-non-zero-val '(#(1 0 1 2 1 2 2 2) #(1 0 1 2 2 2 1 2) #(1 0 2 0 2 2 2 1) #(1 0 2 2 2 0 2 1) #(1 0 0 2 2 2 0 2) #(1 0 1 0 2 1 2 2) #(1 0 2 0 1 2 1 2) #(1 0 2 1 0 1 2 2) #(1 0 2 2 2 1 0 1) #(1 0 0 1 0 2 2 2) #(1 0 0 1 2 0 2 2) #(1 0 0 2 1 0 2 2) #(1 0 1 0 2 2 2 0) #(1 0 2 0 2 0 1 2) #(1 0 2 1 0 2 0 2) #(1 0 2 2 0 1 2 0) #(1 0 2 2 0 2 1 0) #(1 0 2 2 2 0 1 0) #(1 0 2 0 2 0 2 0) #(1 0 1 0 1 2 1 2) #(1 0 0 2 0 1 2 1) #(1 0 0 2 1 0 1 2) #(1 0 1 0 1 0 2 2) #(1 0 1 0 2 1 0 2) #(1 0 1 2 1 0 2 0) #(1 0 2 0 1 0 1 2) #(1 0 2 0 1 2 0 1) #(1 0 2 1 0 1 0 2) #(1 0 2 2 0 1 0 1) #(1 0 0 2 0 1 0 2) #(1 0 0 2 0 2 1 0) #(1 0 2 0 1 0 2 0) #(1 0 1 0 1 0 1 2) #(1 0 1 0 1 2 1 0) #(1 0 2 1 0 1 0 1) #(1 0 0 1 0 1 2 0) #(1 0 0 1 0 2 1 0) #(1 0 2 0 1 0 1 0) #(1 0 1 0 1 1 1 1) #(1 0 1 0 1 0 1 0)) 8)
          :test #'equalp
          :fail-info "Test 23")


    (test #(1 0 1 1 1 1)
          (is-function-non-zero? '(#(1 0 1 0 1 0) #(1 0 1 0 0 1) #(1 0 0 1 1 0) #(1 0 0 1 0 1) #(1 0 1 1 1 1) #(2 0 1 0 1 0) #(0 1 0 2 1 0) #(2 1 0 1 0 1) #(1 0 1 2 1 0) #(1 0 1 0 1 2) #(2 0 1 0 2 0) #(0 2 0 2 1 0) #(0 2 0 1 0 2) #(2 2 0 1 0 1) #(2 1 0 1 0 2) #(2 0 1 2 0 1) #(2 0 1 0 1 2) #(1 2 1 0 2 0) #(1 0 2 1 0 2) #(1 0 1 0 2 2) #(0 2 1 0 1 2) #(1 0 1 2 1 2) #(2 0 2 0 2 0) #(2 2 2 0 1 0) #(2 2 0 2 1 0) #(2 2 0 1 2 0) #(2 1 0 2 0 2) #(2 0 2 0 1 2) #(1 0 2 2 2 0) #(0 2 1 0 2 2) #(0 2 0 2 2 1) #(0 1 2 0 2 2) #(0 1 0 2 2 2) #(2 2 2 1 0 1) #(2 1 0 1 2 2) #(2 0 1 2 1 2) #(1 0 2 1 2 2) #(0 2 2 2 0 2) #(2 2 2 0 2 1) #(2 0 2 2 2 1) #(1 2 2 2 1 2) #(1 2 1 2 2 2)) 6)
          :test #'equalp
          :fail-info "Test 24")
    

    (test nil
          (rsm.bool-comp::try-to-find-non-zero-val '(#(1 0 0 1 2 2) #(1 0 0 2 2 1) #(1 0 2 0 1 2) #(1 0 2 1 0 2) #(1 0 0 2 0 2) #(1 0 2 0 2 0) #(1 0 1 0 1 2) #(1 0 1 2 0 1) #(1 0 1 2 1 0) #(1 0 1 1 1 1) #(1 0 0 1 1 0) #(1 0 1 0 0 1)) 6)
          :fail-info "Test 25")

    (test #(1 0 1 1 1 1)
          (is-function-non-zero? '(#(1 0 0 1 2 2) #(1 0 0 2 2 1) #(1 0 2 0 1 2) #(1 0 2 1 0 2) #(1 0 0 2 0 2) #(1 0 2 0 2 0) #(1 0 1 0 1 2) #(1 0 1 2 0 1) #(1 0 1 2 1 0) #(1 0 1 1 1 1) #(1 0 0 1 1 0) #(1 0 1 0 0 1)) 6)
          :test #'equalp
          :fail-info "Test 26")


    (test nil
          (rsm.bool-comp::try-to-find-non-zero-val '(#(1 0 0 1 2 2) #(1 0 0 2 2 1) #(1 0 0 1 1 0) #(1 0 1 0 0 1)) 6)
          :fail-info "Test 27")


    (test #(0 1 0 1 0 0 0 0 1 1 0 0 1 1 1 0)
          (is-function-non-zero? '(#(2 1 2 1 2 2 1 0 1 1 0 1 2 2 1 1) #(1 2 1 2 2 2 1 2 1 0 1 2 0 1 1 1) #(2 1 2 1 2 2 2 2 1 1 0 2 1 1 1 2)) 16)
          :test #'equalp
          :fail-info "Test 28")
    
    (test #(0 1 0 0 0 0 1 1 0 0 1 1 1 0)
          (is-function-non-zero? '(#(2 1 2 2 1 0 1 1 0 1 2 2 1 1) #(1 2 2 2 1 2 1 0 1 2 0 1 1 1) #(2 1 2 2 2 2 1 1 0 2 1 1 1 2)) 14)
          :test #'equalp
          :fail-info "Test 29")

    (test #(1 1 1 1 1 1 0 1 1 1 1 1)
          (is-function-non-zero? '(#(2 2 1 2 1 0 1 2 0 1 1 1) #(2 2 1 0 1 1 0 1 2 2 1 1) #(2 2 2 2 1 1 0 2 1 1 1 2)) 12)
          :test #'equalp
          :fail-info "Test 30")

    (test '((#(1 2 0 2 1 0 1 2 0 1 1 1) #(1 2 0 0 1 1 0 1 2 2 1 1)) 2 1)
          (multiple-value-list 
           (rsm.bool-comp::is-function-clearly-non-symmetric? '(#(2 2 1 2 1 0 1 2 0 1 1 1) #(2 2 1 0 1 1 0 1 2 2 1 1) #(2 2 2 2 1 1 0 2 1 1 1 2)) 12 1 0))
          :test #'equalp
          :fail-info "Test 31")

    (test nil
          (is-function-non-zero? '(#(0 1 0 2) #(0 1 2 0) #(0 1 0 1) #(0 1 1 0)) 4)
          :fail-info "Test 32")


    (test nil
          (is-function-non-zero? '(#(1 0 0 1) #(1 1 0 0) #(1 1 0 2) #(1 2 0 2) #(1 2 0 0)) 4)
          :fail-info "Test 33")


    (test #(1 1 0 1 1 1 1 1)
          (is-function-non-zero? '(#(0 1 1 0 1 1 0 0) #(0 1 1 0 1 0 1 0) #(1 0 1 0 0 1 1 0) #(0 1 1 0 1 0 0 0) #(1 0 0 1 0 0 0 1) #(0 1 0 1 0 0 0 0) #(0 1 0 0 0 1 1 1) #(1 0 0 0 0 0 1 1) #(0 1 0 0 0 0 0 0) #(0 1 1 1 1 1 1 1) #(0 0 0 1 1 1 1 1) #(0 0 0 0 0 0 1 1) #(0 0 0 0 0 0 0 1) #(0 0 0 0 0 0 0 0) #(1 0 2 0 2 1 2 0) #(0 2 0 1 2 0 1 2) #(1 0 1 0 2 1 2 0) #(1 2 0 2 1 2 1 2) #(2 1 0 2 1 0 2 0) #(1 2 1 0 2 0 2 0) #(1 0 1 0 2 0 2 1) #(1 0 1 0 2 1 0 1) #(0 1 2 0 1 0 2 0) #(1 0 1 0 1 0 1 0) #(1 2 0 1 0 2 1 2) #(0 1 0 1 0 2 1 0) #(1 0 2 1 2 0 1 2) #(2 0 2 0 2 0 1 0) #(1 0 2 0 2 1 0 2) #(1 2 0 1 2 0 1 2) #(2 1 0 1 0 1 0 2) #(0 2 0 2 0 2 0 1) #(0 2 0 2 1 2 0 1) #(1 2 1 0 1 2 1 0) #(2 0 2 1 0 1 2 0) #(2 0 2 0 2 0 2 1) #(1 2 1 0 2 1 2 0) #(1 2 1 0 1 2 1 0) #(1 0 1 2 1 2 0 2) #(0 2 0 2 1 2 0 2) #(2 0 2 1 0 1 0 2) #(0 1 0 2 1 2 1 2) #(1 2 1 2 1 0 2 0) #(2 0 2 0 2 0 1 0) #(0 1 0 1 0 1 0 1) #(0 2 0 1 2 1 2 0) #(1 0 2 0 1 0 2 0) #(2 1 0 2 0 1 2 1) #(1 0 1 0 1 2 0 1) #(2 1 2 0 1 2 0 2) #(2 1 0 1 2 0 2 1) #(2 0 1 0 1 2 1 2) #(2 1 0 1 2 0 2 1) #(1 0 1 0 2 1 0 2) #(0 1 2 0 2 1 2 0) #(0 2 0 1 0 1 0 2) #(0 2 0 2 1 2 0 2) #(1 0 1 0 1 2 0 2) #(1 0 1 2 0 1 2 1) #(1 0 2 1 2 1 0 1) #(0 2 0 1 0 2 1 2) #(1 2 1 2 1 0 2 0) #(2 1 2 1 2 1 0 1) #(2 0 2 0 2 1 0 1) #(1 2 0 1 0 2 0 1) #(1 0 2 0 2 1 0 2) #(0 2 0 2 0 2 0 2) #(1 2 1 0 1 0 1 2) #(1 0 2 0 1 2 0 2) #(0 1 2 0 2 0 2 1) #(2 0 2 1 0 1 2 1) #(0 2 0 1 2 1 2 1) #(1 2 0 2 0 1 2 0) #(0 2 1 0 1 0 1 0) #(1 0 1 2 0 1 2 1) #(2 1 2 1 0 1 0 1) #(1 0 1 2 0 2 1 2) #(0 2 0 2 1 0 2 0) #(1 0 1 2 0 1 2 0) #(1 2 0 2 1 0 2 1) #(2 0 1 2 0 2 1 2) #(1 0 1 2 1 2 1 0) #(0 1 0 2 0 1 0 2) #(2 1 2 0 2 1 0 1) #(0 1 0 2 0 2 0 1) #(0 2 0 2 1 0 1 2) #(0 2 1 2 1 0 2 0) #(1 2 1 2 0 2 0 2) #(0 1 2 1 2 1 2 1) #(0 1 2 1 2 0 2 1) #(1 2 1 0 2 0 2 1) #(2 0 2 1 0 1 0 1) #(0 2 0 2 0 2 1 0) #(1 0 2 1 0 1 0 1) #(2 1 0 1 2 1 2 0) #(1 2 1 2 0 1 2 1) #(1 2 1 2 0 1 2 0) #(1 2 0 1 0 2 1 0) #(2 1 2 0 2 1 2 0) #(1 0 1 0 1 2 0 2) #(0 1 2 0 2 0 2 1) #(2 0 1 2 1 0 1 2) #(1 2 0 2 1 2 0 1) #(2 1 2 1 2 1 0 1) #(0 1 0 2 0 1 0 1) #(0 2 1 2 1 2 0 1) #(1 0 1 2 0 1 0 1) #(1 0 2 0 1 2 1 0) #(2 1 0 2 0 1 0 1) #(1 0 2 0 1 2 0 1) #(0 2 1 0 2 0 2 0) #(0 2 1 0 2 0 2 0) #(0 1 0 1 0 2 1 2) #(1 2 1 2 1 2 0 1) #(1 0 1 0 1 1 1 1) #(1 0 0 0 1 0 0 1) #(0 1 0 1 0 1 1 1) #(1 0 1 0 0 1 1 1) #(0 1 0 1 0 0 1 0) #(1 0 1 0 0 0 1 0) #(1 0 1 1 0 0 1 0) #(1 0 1 1 0 0 0 0) #(1 0 1 1 0 1 0 0) #(0 1 1 0 1 1 0 1) #(0 1 0 1 1 1 0 1) #(1 0 1 1 0 1 1 0) #(0 1 1 1 0 1 1 1) #(0 1 0 0 0 1 1 2) #(0 1 0 0 0 1 1 1) #(1 0 0 0 1 0 1 1) #(1 0 0 1 0 0 1 1) #(1 0 1 0 0 0 1 1) #(1 0 0 0 0 1 0 1) #(1 0 0 1 0 1 0 0) #(1 0 1 0 0 1 0 0) #(0 1 0 0 1 1 0 0) #(0 1 0 1 0 1 0 1) #(0 1 1 0 0 1 0 1) #(0 1 0 0 1 1 0 1) #(0 1 1 1 1 0 1 1) #(0 1 0 0 0 0 1 0) #(1 0 1 1 1 1 0 0) #(1 0 1 1 1 1 0 1) #(1 0 1 1 1 1 1 0)) 8)
          :test #'equalp
          :fail-info "Test 34")
    
    (test nil
;;; There is a non-zero value -  #(1 0 0 1 2 2 2 1) - but not a real value with 0's and 1's.
          (rsm.bool-comp::try-to-find-non-zero-val '(#(1 0 2 1 2 2 2 1) #(1 0 1 0 2 2 2 2) #(1 0 1 2 2 2 0 2) #(1 0 0 1 2 1 2 2) #(1 0 1 2 0 1 2 2) #(1 0 1 2 2 1 2 0) #(1 0 2 1 0 1 2 2) #(1 0 2 1 2 0 1 2) #(1 0 2 2 1 0 1 2) #(1 0 0 2 1 0 2 2) #(1 0 2 0 2 0 2 1) #(1 0 2 0 2 1 2 0) #(1 0 2 2 0 1 2 0) #(1 0 2 2 1 0 2 0) #(1 0 0 2 0 2 0 2) #(1 0 1 0 1 2 1 2) #(1 0 1 2 1 2 1 0) #(1 0 2 1 0 1 2 1) #(1 0 2 1 2 1 0 1) #(1 0 0 1 0 2 1 2) #(1 0 0 1 2 1 2 0) #(1 0 0 2 0 1 2 1) #(1 0 0 2 2 1 0 1) #(1 0 1 0 2 0 2 1) #(1 0 1 0 2 1 0 2) #(1 0 2 0 1 2 0 1) #(1 0 2 0 1 2 1 0) #(1 0 2 1 0 1 0 2) #(1 0 2 2 0 1 0 1) #(1 0 0 2 0 1 0 2) #(1 0 0 2 0 2 1 0) #(1 0 0 2 0 0 2 0) #(1 0 1 1 1 2 1 1) #(1 0 1 0 1 0 1 2) #(1 0 1 0 1 1 0 2) #(1 0 1 0 1 2 0 1) #(1 0 0 0 0 1 1 2) #(1 0 0 0 1 0 2 1) #(1 0 0 1 0 0 2 1) #(1 0 0 1 0 2 0 1) #(1 0 1 0 0 1 2 0) #(1 0 1 0 1 0 2 0) #(1 0 1 0 2 0 1 0) #(1 0 1 1 0 0 2 0) #(1 0 2 0 0 0 1 1) #(1 0 2 0 0 1 0 1) #(1 0 1 1 1 1 0 1) #(1 0 1 0 1 0 1 0) #(1 0 0 0 1 1 0 0) #(1 0 0 1 0 1 0 0)) 8)
          :fail-info "Test 35")

    (test #(0 1 1 1 0 1 0 1 1 1 1 1 1 1 0 0 1 1 1 0)
          (is-function-non-zero? '(#(1 2 0 1 2 1 2 1 2 2 1 0 1 1 0 1 2 2 1 1) #(2 2 2 1 0 2 1 0 2 2 1 2 2 2 0 0 2 2 2 0) #(1 1 2 1 2 1 0 0 2 2 0 1 0 0 1 1 0 2 0 2) #(2 1 2 1 2 1 2 1 2 2 2 2 1 1 0 2 1 1 1 2) #(1 2 1 2 1 2 1 2 2 2 1 2 1 0 1 2 0 1 1 1) #(0 1 1 1 1 1 1 1 2 2 2 1 0 1 2 1 2 1 0 2) #(0 1 1 1 1 1 1 1 1 1 1 1 1 1 2 2 1 2 2 2) #(0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 2 2 0 0) #(0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1) #(1 2 1 1 2 1 2 1 2 2 1 0 1 1 0 1 2 2 1 1) #(2 0 2 1 0 2 1 0 2 2 1 2 2 2 0 0 2 2 2 0) #(1 1 2 1 2 1 2 1 2 2 0 1 0 0 1 1 0 2 0 2) #(2 1 2 1 2 1 2 1 2 1 2 1 1 1 0 2 1 1 1 2) #(1 2 1 2 1 2 1 2 2 2 1 2 1 0 1 2 0 1 1 1) #(0 1 1 1 2 2 0 1 2 2 2 1 0 1 2 1 2 1 0 2) #(0 1 1 1 2 1 2 1 1 1 1 1 1 1 2 2 1 2 2 2) #(0 1 1 0 2 1 2 1 1 1 1 1 1 1 1 1 2 2 0 0) #(0 1 1 1 0 2 2 0 2 2 1 1 1 1 1 1 1 1 1 1) #(0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1) #(0 1 2 1 0 2 1 0 2 2 1 2 2 2 0 0 2 2 2 0) #(0 1 0 1 0 1 0 1 1 0 1 1 1 1 0 1 1 1 1 1) #(0 1 0 1 0 1 0 1 0 0 1 1 1 1 0 1 1 1 1 1) #(0 1 0 1 0 1 0 1 1 0 0 1 1 1 0 1 1 1 1 1) #(0 1 0 1 0 1 0 1 0 0 0 1 1 1 0 1 1 1 1 1) #(0 1 0 1 0 1 0 1 1 1 0 0 1 1 0 1 1 1 1 1) #(0 1 0 1 0 1 0 1 0 1 0 0 1 1 0 1 1 1 1 1) #(0 1 0 1 0 1 0 1 1 0 0 0 1 1 0 1 1 1 1 1) #(0 1 0 1 0 1 0 1 0 0 0 0 1 1 0 1 1 1 1 1) #(0 1 0 1 0 1 0 1 1 0 1 1 1 1 0 0 1 1 1 1) #(0 1 0 1 0 1 0 1 0 0 1 1 1 1 0 0 1 1 1 1) #(0 1 0 1 0 1 0 1 1 0 0 1 1 1 0 0 1 1 1 1) #(0 1 0 1 0 1 0 1 0 0 0 1 1 1 0 0 1 1 1 1) #(0 1 0 1 0 1 0 1 1 1 1 0 1 1 0 0 1 1 1 1) #(0 1 0 1 0 1 0 1 0 1 1 0 1 1 0 0 1 1 1 1) #(0 1 0 1 0 1 0 1 1 0 1 0 1 1 0 0 1 1 1 1) #(0 1 0 1 0 1 0 1 0 0 1 0 1 1 0 0 1 1 1 1) #(0 1 0 1 0 1 0 1 1 1 0 0 1 1 0 0 1 1 1 1) #(0 1 0 1 0 1 0 1 0 1 0 0 1 1 0 0 1 1 1 1) #(0 1 0 1 0 1 0 1 1 0 0 0 1 1 0 0 1 1 1 1) #(0 1 0 1 0 1 0 1 0 0 0 0 1 1 0 0 1 1 1 1) #(1 0 0 1 0 1 0 1 1 1 1 0 1 1 0 1 0 1 1 1) #(1 0 0 1 0 1 0 1 0 1 1 0 1 1 0 1 0 1 1 1) #(1 0 0 1 0 1 0 1 1 0 1 0 1 1 0 1 0 1 1 1) #(1 0 0 1 0 1 0 1 0 0 1 0 1 1 0 1 0 1 1 1) #(1 0 0 1 0 1 0 1 1 1 1 0 1 1 0 1 1 0 1 1) #(1 0 0 1 0 1 0 1 0 1 1 0 1 1 0 1 1 0 1 1) #(1 0 0 1 0 1 0 1 1 0 1 0 1 1 0 1 1 0 1 1) #(1 0 0 1 0 1 0 1 0 0 1 0 1 1 0 1 1 0 1 1) #(1 0 0 1 0 1 0 1 1 1 1 0 1 1 0 1 0 0 1 1) #(1 0 0 1 0 1 0 1 0 1 1 0 1 1 0 1 0 0 1 1) #(1 0 0 1 0 1 0 1 1 0 1 0 1 1 0 1 0 0 1 1) #(1 0 0 1 0 1 0 1 0 0 1 0 1 1 0 1 0 0 1 1) #(0 1 0 1 0 1 0 1 1 0 1 1 1 1 0 1 1 1 1 0) #(0 1 0 1 0 1 0 1 0 0 1 1 1 1 0 1 1 1 1 0) #(0 1 0 1 0 1 0 1 1 0 0 1 1 1 0 1 1 1 1 0) #(0 1 0 1 0 1 0 1 0 0 0 1 1 1 0 1 1 1 1 0) #(0 1 0 1 0 1 0 1 1 1 1 0 1 1 0 1 1 1 1 0) #(0 1 0 1 0 1 0 1 0 1 1 0 1 1 0 1 1 1 1 0) #(0 1 0 1 0 1 0 1 1 0 1 0 1 1 0 1 1 1 1 0)) 20)
          :test #'equalp
          :fail-info "Test 36")

    (test #(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
          (is-function-non-zero? '(#(1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2) #(1 0 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2) #(1 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2) #(2 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2) #(0 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2) #(1 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2) #(2 2 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2) #(0 2 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 0) #(1 2 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 1 0 2) #(0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1) #(0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1) #(1 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0) #(1 0 1 0 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 1 2 0 0 2) #(1 0 1 0 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 1 2 0 2 0 0 2) #(1 0 1 0 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 1 2 0 2 0 2 0 0 2) #(1 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0) #(1 0 1 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0) #(1 0 1 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0) #(1 0 1 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0) #(1 0 1 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0) #(1 0 1 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0) #(1 0 1 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0) #(1 0 1 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0) #(1 0 1 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0) #(1 0 1 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0) #(1 0 1 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)) 32)
          :test #'equalp
          :fail-info "Test 37")
    

    (test #(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
          (is-function-non-zero? '(#(1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2) #(1 0 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2) #(1 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2) #(2 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2) #(0 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2) #(1 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2) #(2 2 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2) #(0 2 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 0) #(1 2 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 1 0 2) #(0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1) #(0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1) #(1 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0) #(1 0 1 0 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 1 2 0 0 2) #(1 0 1 0 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 1 2 0 2 0 0 2) #(1 0 1 0 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 1 2 0 2 0 2 0 0 2) #(1 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0) #(1 0 1 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0) #(1 0 1 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0) #(1 0 1 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0) #(1 0 1 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0) #(1 0 1 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0) #(1 0 1 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0) #(1 0 1 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0) #(1 0 1 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0) #(1 0 1 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0) #(1 0 1 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0) #(1 0 1 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0) #(1 0 1 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0) #(1 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0) #(1 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0) #(1 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0) #(1 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0) #(1 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0) #(1 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0)) 32)
          :test #'equalp
          :fail-info "Test 38")
    

    (test '(#(1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 0 2 0 2 0 2 0 0 2))
          (rsm.bool-comp::sym-diff '(#(2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 1 2 0 2 0 2 0 0 2)) 0 19 28 1)
          :test #'equalp
          :fail-info "Test 39")

    
    (test #(1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
          (is-function-non-zero? '(#(0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0) #(0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0) #(0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0) #(0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0) #(0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0) #(0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0) #(0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0) #(0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0) #(0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0) #(0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0) #(0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0) #(0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0) #(0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0) #(0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0) #(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0) #(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0) #(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0) #(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0) #(2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0) #(2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 1 2 0 2 0 2 0 0 2) #(2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 1 2 0 2 0 0 2) #(2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 1 2 0 0 2) #(2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 1 0 2) #(2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 0)) 28)
          :test #'equalp
          :fail-info "Test 40")


    (test #(1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
          (rsm.bool-comp::try-to-find-non-zero-val '(#(1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 0 2 0 2 0 2 0 0 2) #(1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)) 28)
          :test #'equalp
          :fail-info "Test 41")


    (test '(#(1 1) #(2 1))
          (convert-tree->xor '(^ (^ #(2 1) #(1 2)) (^ #(1 2) #(1 1))) 2)
          :test #'equalp
          :fail-info "Test 42")

    (test "x1*x2 ^ x2"
          (list->eqn (convert-tree->xor '(^ (^ #(2 1) #(1 2)) (^ #(1 2) #(1 1))) 2))
          :test #'equalp
          :fail-info "Test 43")


    (test "x2*x3' ^ x1*x3"
          (list->eqn (convert-tree->xor '(+ #(1 2 1) #(2 1 0) #(1 0 1)) 3))
          :test #'equalp
          :fail-info "Test 44")


    (test "x1'*x2'*x3'*x4'*x5'*x6 ^ x1'*x2'*x3'*x4'*x5 ^ x1'*x2'*x3'*x4 ^ x1'*x2'*x3 ^ x1 ^ x1'*x2"
          (list->eqn (convert-tree->xor '(+ #(1 2 2 2 2 2 2 2) #(2 1 2 2 2 2 2 2) #(2 2 1 2 2 2 2 2) #(2 2 2 1 2 2 2 2) #(2 2 2 2 1 2 2 2) #(2 2 2 2 2 1 2 2)) 8))
          :test #'equalp
          :fail-info "Test 45")
    
    (test '(#(1 2 1) #(2 2 1) #(1 2 2))
          (formula->rep "X1 + X3 * X3")
          :test #'equalp
          :fail-info "Test 46")
    
    (test  "x1*x2*x3 ^ x2*x3 ^ x1"
           (list->eqn '(#(1 1 1) #(2 1 1) #(1 2 2)))
           :test #'string-equal
           :fail-info "Test 47")

    
    (test '(#(1 2 2) #(0 2 1))
          (formula->rep "X1 + X3")
          :test #'equalp
          :fail-info "Test 48")

    (test "x1 ^ x1'*x3"
          (list->eqn '(#(1 2 2) #(0 2 1)))
          :test #'string-equal
          :fail-info "Test 49")

    (test #(0 1 1)
          (bool-solve "X1 + X2*X3")
          :test #'equalp
          :fail-info "Test 50")

    )
  t
  )
