/*
 * Cheops Network User Interface
 *
 * Copyright (C) 1999, Adtran, Inc.
 * 
 * Distributed under the terms of the GNU GPL
 *
 */

#include <gtk/gtk.h>
#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <arpa/inet.h>
#include <string.h>
#include <netdb.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include "cheops.h"

void save_geometry() 
{
	char *c;
	char  buf[256];
	FILE *f;
	GtkWidget *win = main_window.window;
	if ((c = getenv("HOME"))) {
		snprintf(buf, sizeof(buf), "%s/.cheops",c);
		mkdir(buf, 0700);
		snprintf(buf, sizeof(buf), "%s/.cheops/geometry",c);
		f = fopen(buf, "w");
		if (f) {
			fprintf(f, "%d\n%d\n", win->allocation.width, win->allocation.height);
			fclose(f);
		}
	}
}

void set_geometry(GtkWidget *window)
{
	char buf[256];
	char *c;
	int x=0, y=0;
	FILE *f;
	c = getenv("HOME");
	if (c) {
		snprintf(buf, sizeof(buf), "%s/.cheops/geometry", c);
		f = fopen(buf, "r");
		if (f) {
			if (fscanf(f, "%d\n%d\n", &x, &y) == 2) {
				gtk_widget_set_usize(window, x, y);
				return;
			}
			fclose(f);
		}
	}
	gtk_widget_set_usize(window, 640, 480);
}

void do_save(GtkWidget *w, char *fn)
{
	GtkNotebookPage *page;
	struct net_page *p;
	struct network *nw;
	struct domain *d;
	struct in_addr ia;
	struct alias *a;
	struct pcache *pc;
	struct net_object *no;
	struct link *l;
	GList *li;
	char *label;
	FILE *out;
	char filename[256];
	char buf[256];
	if (fn) {
		strncpy(filename,fn, sizeof(filename));
	} else {
		strncpy(filename, defname, sizeof(filename));
	}
	out = fopen(filename, "w+");
	if (!out) {
		perror("fopen");
		return;
	}
	li = g_list_first(GTK_NOTEBOOK(main_window.notebook)->first_tab);
	while(li) {
		page = (GtkNotebookPage *)(li->data);
		gtk_label_get(GTK_LABEL(page->tab_label), &label);
		fprintf(out, "[page %s]\n", label);
		p = (struct net_page *)gtk_object_get_user_data(GTK_OBJECT(page->child));
		fprintf(out, "[option map %d]\n", p->automap);
		fprintf(out, "[option smallicons %d]\n", p->small_icons);
		fprintf(out, "[option autorefresh %d]\n", p->refsec);
		fprintf(out, "[option listview %d]\n", gtk_notebook_current_page(GTK_NOTEBOOK(p->notebook)));

		if (option_remember_positions) {
			/* First remember the positions of the hosts we want
			   to remember */
			pc = p->pos;
			while(pc) {
				ia.s_addr = pc->addr;
				fprintf(out,"[position %s %d %d]\n", inet_ntoa(ia), pc->x, pc->y);
				pc = pc->next;
			}
		}
		if (option_remember_connects) {
			no = p->objs;
			while(no) {
				l = no->links;
				while(l) {
					if (no < l->other) {
						/* Only get one of each link */
						ia.s_addr = no->ip_addr;
						fprintf(out, "[connect %s", inet_ntoa(ia));
						ia.s_addr = l->other->ip_addr;
						fprintf(out, " %s]\n", inet_ntoa(ia));
					}
					l = l->next;
				}
				no = no->next;
			}
		}

		if (option_remember_hosts) {
			/* Then remember all hosts, so they don't get discovered
			   again */
			no = p->objs;
			while(no) {
				ia.s_addr = no->ip_addr;
				fprintf(out,"[host %s %s %s [%s]", inet_ntoa(ia), no->hostname, no->fn, no->os);
				if (option_remember_aliases) {
					a = no->aliases;
					while(a) {
						fprintf(out, " %s",a->hostname);
						a=a->next;
					}
				}
				fprintf(out,"]\n");
				no=no->next;
			}
		}
		/* List domains first */				
		d = p->dcontents;
		while(d) {
			fprintf(out, "[domain %s %d]\n", d->domain, d->recursive);
			d=d->next;
		}
		/* Then networks, so we have aliases if available */
		nw = p->ncontents;
		while(nw) {
			ia.s_addr = nw->net_addr;
			fprintf(out, "[network %s", inet_ntoa(ia));
			ia.s_addr = nw->net_mask;
			fprintf(out, " %s]\n", inet_ntoa(ia));
			nw=nw->next;
		}
		li = g_list_next(li);
	}
	fclose(out);
	strncpy(defname, filename, sizeof(defname));
	g_snprintf(buf, sizeof(buf), "Saved '%s'", filename);
	set_status(buf);
}

void fix_label(struct net_object *no)
{
	char *c;
	char buf[256];
#ifdef USE_CANVAS	
	double x1, y1, x2, y2;
#endif
	strncpy(buf, no->hostname, sizeof(buf));
	c = buf;
 	if (option_trim) {
		/* Don't trim IP addresses */
		if (!atoi(c)) {
			do {
				c = strchr(c,'.');
				/* See if this is a domain name */
				if (c) {
					if (get_server(c+1, 0)) {
						*c = '\0';
						break;
					} else
						c++;
				}
			} while(c);
		}
	}
#ifdef USE_CANVAS
	gnome_canvas_item_set(no->label, "text", buf, NULL);
	gnome_canvas_item_get_bounds(no->label, &x1, &y1, &x2, &y2);
	gnome_canvas_item_set(no->rect, "x1", x1 - 2, "x2", x2 + 2, "y1", y1 - 2, "y2", y2 + 2, NULL);
#else
	gtk_label_set(GTK_LABEL(no->label), buf);
#endif
	check_label(no);
}

int do_load(char *fn)
{
	char filename[256];
	char buf[256];
	char *key, *c, *d, *e;
	FILE *f;
	int res=0;
	struct net_page *np=NULL;
	
	if (fn) {
		strncpy(filename, fn, sizeof(filename));
	} else {
		strncpy(filename, defname, sizeof(filename));
	}
	f = fopen(filename, "r");
	if (!f) {
		g_snprintf(buf, sizeof(buf), "Unable to open '%s'", filename);
		if (fn)
			set_status(buf);
		return 0;
	}
	res=1;
	while(!feof(f)) {
		fgets(buf, sizeof(buf), f);
		if (feof(f)) break;
		key = strtok(buf, " ");
		if (!strcasecmp(key, "[page")) {
			c = buf + 6;
			if (!*c)
				continue;
			if (!strtok(c, "]"))
				continue;
			np=add_network(&main_window, c);
		} else 
		if (!strcasecmp(key,"[option")) {
			/* c = option name
			   d = option value */
			if (!np)
				continue;
			c = strtok(NULL, " ");
			if (!c)
				continue;
			d = strtok(NULL, " ");
			if (!d)
				continue;
			if (!strtok(d, "]"))
				continue;
			if (!strcasecmp(c, "map")) {
				np->automap=atoi(d);
			}
			if (!strcasecmp(c, "smallicons")) {
				if (atoi(d) && !np->small_icons) {
					np->small_icons = 2;
					np->icon_height /= 2;
					np->icon_width /= 2;
				}
			}
			if (!strcasecmp(c, "autorefresh")) {
				if (atoi(d)) {
					np->refsec = atoi(d);
					np->refid = gtk_timeout_add(atoi(d) * 1000, do_refresh, np);
				}
			}
			if (!strcasecmp(c, "listview")) {
				if (atoi(d)) 
					gtk_notebook_set_page(GTK_NOTEBOOK(np->notebook), 1);
				else
					gtk_notebook_set_page(GTK_NOTEBOOK(np->notebook), 0);
				
			}
		} else
		if (!strcasecmp(key,"[network")) {
			/* c = network
			   d = netmask */
			if (!np)
				continue;
			c = strtok(NULL, " ");
			if (!c) continue;			
			d = strtok(NULL, " ");
			if (!d) continue;
			if (!strtok(d, "]"))
				continue;
			discover_network_a(np, c, d, 1);
		} else
		if (!strcasecmp(key,"[domain")) {
			/* c = domain
			   d = recurse domains */
			if (!np)
				continue;
			c = strtok(NULL, " ");
			if (!c) continue;
			d = strtok(NULL, " ");
			if (!d) continue;
			if (!strtok(d, "]")) continue;
			gather_hosts(np, c, atoi(d), 1);
		} else 
		if (!strcasecmp(key,"[position")) {
			int x, y;
			struct hostent *hp;
			struct pcache *pc;
			/* c = host
			   d = x pos
			   e = y pos */
			if (!np)
				continue;
			c = strtok(NULL, " ");
			if (!c) continue;
			d = strtok(NULL, " ");
			if (!d) continue;
			e = strtok(NULL, " ");
			if (!e) continue;
			x = atoi(d);
			if (!strtok(e, "]")) continue;
			y = atoi(e);
			hp = gethostbyname(c);
			if (!hp) {
				fprintf(stderr, "Load Warning: No such host %s\n",c);
				continue;
			}
			pc = get_cache(np, *(unsigned int *)hp->h_addr);
			pc->x = x;
			pc->y = y;
		} else  
		if (!strcasecmp(key,"[host")) {
			struct in_addr ia;
			int ordns;
			char *f, *g;
			struct net_object *no;
			/* c = IP address
			   d = hostname
			   e = pixmap
			   f = os
			*/

			if (!np) continue;
			c = strtok(NULL, " ");
			if (!c) continue;
			d = strtok(NULL, " ");
			if (!d) continue;
			e = strtok(NULL, " ");
			if (!e) continue;
			f = strtok(NULL, "[");
			if (!f) continue;
			g = strtok(f, "]");
			if (!g) continue;
		
#if 0
			g = strtok(g, "]");
			if (!g) continue;
#endif
			if (!inet_aton(c, &ia)) continue;
			/* We don't want to reverse DNS on these entries,
			   nor automap them */
			ordns = option_reverse_dns;
			option_reverse_dns=0;
			add_unique(ia.s_addr, e, f, np);
			option_reverse_dns=ordns;
			no = get_object(np, ia.s_addr);
			strncpy(no->hostname, d, sizeof(no->hostname));
			fix_label(no);
			fix_tooltip(no);
		} else
		if (!strcasecmp(key, "[connect")) {
			struct in_addr ia;
			struct in_addr ia2;
			/* c = IP 1
			   d = IP 2
			  */
			if (!np) continue;
			c = strtok(NULL, " ");
			if (!c) continue;
			d = strtok(NULL, " ");
			if (!d) continue;
			if (!strtok(d, "]")) continue;
			if (!inet_aton(c, &ia)) continue;
			if (!inet_aton(d, &ia2)) continue;
			map_connect(np, ia.s_addr, ia2.s_addr, 0);
		}
	}
	fclose(f);
	strncpy(defname, filename, sizeof(defname));
	g_snprintf(buf, sizeof(buf), "Loaded '%s'", filename);
	set_status(buf);
	return res;
}

struct pcache *get_cache(struct net_page *np, unsigned int addr)
{
	struct pcache *pc;
	struct in_addr ia;
	pc = np->pos;
	while(pc) {
		if (pc->addr == addr)
			return pc;
		pc=pc->next;
	}
	ia.s_addr = addr;
	pc = g_new0(struct pcache, 1);
	pc->x=0;
	pc->y=0;
	pc->addr = addr;
	pc->next = np->pos;
	np->pos = pc;
	return pc;
}

struct pcache *check_cache(struct net_page *np, unsigned int addr)
{
	struct pcache *pc;
	pc = np->pos;
	while(pc) {
		if (pc->addr == addr)
			return pc;
		pc=pc->next;
	}
	return pc;
}

