/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc;

import com.sap.dbtech.jdbc.ConnectionSapDB;
import com.sap.dbtech.jdbc.DriverSapDB;
import com.sap.dbtech.jdbc.MemoryResultSetSapDB;
import com.sap.dbtech.jdbc.ResultSetSapDB;
import com.sap.dbtech.jdbc.exceptions.DatabaseException;
import com.sap.dbtech.jdbc.exceptions.InternalJDBCError;
import com.sap.dbtech.jdbc.exceptions.InvalidArgumentValue;
import com.sap.dbtech.util.Tracer;
import com.sap.dbtech.util.VersionInfo;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DatabaseMetaDataSapDB
implements DatabaseMetaData {
    public static final String defaultCatalogName = "";
    private ConnectionSapDB connection;
    private VersionInfo dbVersionInfo = null;
    private String dbVersion = null;
    private String dbName = null;
    private final String typename2odbc_C = "'CHAR', 1, 'CHAR() ASCII', 1, 'CHAR() EBCDIC', 1, 'CHAR() UNICODE', 1, 'CHAR() BYTE', -2, 'VARCHAR', 12, 'VARCHAR() ASCII', 12, 'VARCHAR() EBCDIC', 12, 'VARCHAR() UNICODE', 12, 'VARCHAR() BYTE', -3, 'LONG', -1, 'LONG ASCII', -1, 'LONG EBCDIC', -1, 'LONG UNICODE', -1, 'LONG BYTE', -4, 'LONG RAW', -4, 'FIXED', 3, 'DECIMAL', 3, 'REAL', 7, 'FLOAT', 6, 'DOUBLE PRECISION', 8, 'SMALLINT', 5, 'INTEGER', 4, 'BOOLEAN', -7, 'TIME', 92, 'DATE', 91, 'TIMESTAMP', 93, 'NUMBER', 2, 1111";
    private final String DataTypeSuffix_C = "'CHAR','CHAR()','VARCHAR','VARCHAR()','LONG','LONG','LONG RAW','LONG',datatype";

    DatabaseMetaDataSapDB(ConnectionSapDB connectionSapDB, VersionInfo versionInfo) throws SQLException {
        this.connection = connectionSapDB;
        this.dbName = connectionSapDB.getConnectProperty("dbname");
        this.dbVersionInfo = versionInfo;
    }

    public boolean allProceduresAreCallable() throws SQLException {
        return false;
    }

    public boolean allTablesAreSelectable() throws SQLException {
        return false;
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    public boolean deletesAreDetected(int n) throws SQLException {
        return false;
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    public ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        ResultSet resultSet;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT 2 SCOPE, columnname COLUMN_NAME, decode (((decode (datatype,'CHAR','CHAR()','VARCHAR','VARCHAR()','LONG','LONG','LONG RAW','LONG',datatype))|| (' ' || (codetype))), 'CHAR', 1, 'CHAR() ASCII', 1, 'CHAR() EBCDIC', 1, 'CHAR() UNICODE', 1, 'CHAR() BYTE', -2, 'VARCHAR', 12, 'VARCHAR() ASCII', 12, 'VARCHAR() EBCDIC', 12, 'VARCHAR() UNICODE', 12, 'VARCHAR() BYTE', -3, 'LONG', -1, 'LONG ASCII', -1, 'LONG EBCDIC', -1, 'LONG UNICODE', -1, 'LONG BYTE', -4, 'LONG RAW', -4, 'FIXED', 3, 'DECIMAL', 3, 'REAL', 7, 'FLOAT', 6, 'DOUBLE PRECISION', 8, 'SMALLINT', 5, 'INTEGER', 4, 'BOOLEAN', -7, 'TIME', 92, 'DATE', 91, 'TIMESTAMP', 93, 'NUMBER', 2, 1111) DATA_TYPE, (decode(datatype,'CHAR','CHAR()','VARCHAR','VARCHAR()','LONG','LONG','LONG RAW','LONG',datatype))|| (' ' || (codetype)) TYPE_NAME, len COLUMN_SIZE, NULL BUFFER_LENGTH, dec DECIMAL_DIGITS, 1 PSEUDO_COLUMN FROM domain.columns ");
        stringBuffer.append("WHERE tablename = '" + string3 + "' ");
        if (this.realQualification(string2)) {
            stringBuffer.append("AND owner = '" + string2 + "' ");
        }
        stringBuffer.append("AND keypos is not null ");
        try {
            resultSet = this.connection.createStatement().executeQuery(stringBuffer.toString());
            try {
                ((ResultSetSapDB)resultSet).setFromMetaData(true);
            }
            catch (ClassCastException classCastException) {}
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() == 100) {
                String[] stringArray = new String[]{"SCOPE", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "PSEUDO_COLUMN"};
                Object[][] objectArray = new Object[][]{{new Integer(2), "SYSKEY", new Integer(-2), "CHARBYTE", new Integer(8), null, null, new Integer(2)}};
                resultSet = new MemoryResultSetSapDB(stringArray, objectArray);
            }
            throw sQLException;
        }
        return resultSet;
    }

    public ResultSet getCatalogs() throws SQLException {
        String[] stringArray = new String[]{"TABLE_CAT"};
        Object[][] objectArray = new Object[][]{{defaultCatalogName}};
        MemoryResultSetSapDB memoryResultSetSapDB = new MemoryResultSetSapDB(stringArray, objectArray);
        return memoryResultSetSapDB;
    }

    public String getCatalogSeparator() throws SQLException {
        return ".";
    }

    public String getCatalogTerm() throws SQLException {
        return "DATABASE";
    }

    public ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT '' TABLE_CAT, table_owner TABLE_SCHEM, TABLE_NAME, COLUMN_NAME, GRANTOR, GRANTEE, PRIVILEGE, IS_GRANTABLE FROM domain.columnprivileges WHERE ");
        stringBuffer.append("table_name = '" + string3 + "' ");
        if (this.realQualification(string2)) {
            stringBuffer.append("AND table_owner = '" + string2 + "' ");
        }
        if (this.realPatternQualification(string4)) {
            stringBuffer.append("AND column_name LIKE '" + string4 + "' ");
        }
        stringBuffer.append(" ORDER BY column_name, privilege ");
        return this.internalQuery(stringBuffer.toString(), "getColumnPrivileges");
    }

    public ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer.append("SELECT '' TABLE_CAT, owner TABLE_SCHEM, tablename TABLE_NAME, columnname COLUMN_NAME, decode (((decode (datatype,'CHAR','CHAR()','VARCHAR','VARCHAR()','LONG','LONG','LONG RAW','LONG',datatype))|| (' ' || (codetype))), 'CHAR', 1, 'CHAR() ASCII', 1, 'CHAR() EBCDIC', 1, 'CHAR() UNICODE', 1, 'CHAR() BYTE', -2, 'VARCHAR', 12, 'VARCHAR() ASCII', 12, 'VARCHAR() EBCDIC', 12, 'VARCHAR() UNICODE', 12, 'VARCHAR() BYTE', -3, 'LONG', -1, 'LONG ASCII', -1, 'LONG EBCDIC', -1, 'LONG UNICODE', -1, 'LONG BYTE', -4, 'LONG RAW', -4, 'FIXED', 3, 'DECIMAL', 3, 'REAL', 7, 'FLOAT', 6, 'DOUBLE PRECISION', 8, 'SMALLINT', 5, 'INTEGER', 4, 'BOOLEAN', -7, 'TIME', 92, 'DATE', 91, 'TIMESTAMP', 93, 'NUMBER', 2, 1111) DATA_TYPE, (decode(datatype,'CHAR','CHAR()','VARCHAR','VARCHAR()','LONG','LONG','LONG RAW','LONG',datatype))|| (' ' || (codetype)) TYPE_NAME, len COLUMN_SIZE, NULL BUFFER_LENGTH, dec DECIMAL_DIGITS, 10 NUM_PREC_RADIX, decode (mode, 'OPT', 1, 0) NULLABLE, comment REMARKS, \"DEFAULT\" COLUMN_DEF, NULL SQL_DATA_TYPE, NULL SQL_DATETIME_SUB, len CHAR_OCTET_LENGTH, ");
        if (this.connection.isSQLModeOracle) {
            stringBuffer.append("ROWNUM ORDINAL_POSITION, ");
        } else {
            stringBuffer.append("ROWNO ORDINAL_POSITION, ");
        }
        stringBuffer.append("decode (mode, 'OPT', 'YES', 'NO') IS_NULLABLE FROM domain.columns ");
        if (this.realPatternQualification(string2)) {
            stringBuffer2.append("AND owner LIKE '" + string2 + "' ");
        }
        if (this.realPatternQualification(string3)) {
            stringBuffer2.append("AND tablename LIKE '" + string3 + "' ");
        }
        if (this.realPatternQualification(string4)) {
            stringBuffer2.append("AND columnname LIKE '" + string4 + "' ");
        }
        if (stringBuffer2.length() > 0) {
            stringBuffer.append(" WHERE 1 = 1 ");
            stringBuffer.append(stringBuffer2.toString());
        }
        stringBuffer.append(" ORDER BY owner, tablename, pos ");
        return this.internalQuery(stringBuffer.toString(), "getColumns");
    }

    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT '' PKTABLE_CAT, PKTABLE_OWNER PKTABLE_SCHEM, PKTABLE_NAME, PKCOLUMN_NAME, '' FKTABLE_CAT, FKTABLE_OWNER FKTABLE_SCHEM, FKTABLE_NAME, FKCOLUMN_NAME, KEY_SEQ, 1 UPDATE_RULE,DELETE_RULE, FK_NAME, PK_NAME, 1 DEFERRABILITY FROM sysodbcforeignkeys ");
        stringBuffer.append("WHERE pktable_name = '" + string3 + "' ");
        stringBuffer.append("AND fktable_name = '" + string6 + "' ");
        if (this.realQualification(string2)) {
            stringBuffer.append("AND PKTABLE_OWNER = '" + string2 + "' ");
        }
        if (this.realQualification(string5)) {
            stringBuffer.append("AND FKTABLE_OWNER = '" + string5 + "' ");
        }
        String string7 = stringBuffer.toString();
        return this.internalQuery(string7, "getCrossReference");
    }

    public String getDatabaseProductName() throws SQLException {
        return "SAP DB";
    }

    public String getDatabaseProductVersion() throws SQLException {
        String string;
        if (this.dbVersion != null) {
            return this.dbVersion;
        }
        ResultSet resultSet = this.internalQuery("Select kernel from domain.versions", "getDatabaseProductVersion");
        resultSet.next();
        this.dbVersion = string = resultSet.getString(1);
        resultSet.close();
        return string;
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        return 2;
    }

    public int getDriverMajorVersion() {
        return DriverSapDB.singleton().getMajorVersion();
    }

    public int getDriverMinorVersion() {
        return DriverSapDB.singleton().getMinorVersion();
    }

    public String getDriverName() throws SQLException {
        return DriverSapDB.singleton().getName();
    }

    public String getDriverVersion() throws SQLException {
        return DriverSapDB.singleton().getVersionString();
    }

    public ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT '' PKTABLE_CAT, PKTABLE_OWNER PKTABLE_SCHEM, PKTABLE_NAME, PKCOLUMN_NAME, '' FKTABLE_CAT, FKTABLE_OWNER FKTABLE_SCHEM, FKTABLE_NAME, FKCOLUMN_NAME, KEY_SEQ, 1 UPDATE_RULE,DELETE_RULE, FK_NAME, PK_NAME, 1 DEFERRABILITY FROM sysodbcforeignkeys ");
        stringBuffer.append("WHERE pktable_name = '" + string3 + "' ");
        if (this.realQualification(string2)) {
            stringBuffer.append("AND PKTABLE_OWNER = '" + string2 + "' ");
        }
        return this.internalQuery(stringBuffer.toString(), "getExportedKeys");
    }

    public String getExtraNameCharacters() throws SQLException {
        return "#@$";
    }

    public String getIdentifierQuoteString() throws SQLException {
        return "\"";
    }

    public ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT '' PKTABLE_CAT, PKTABLE_OWNER PKTABLE_SCHEM, PKTABLE_NAME, PKCOLUMN_NAME, '' FKTABLE_CAT, FKTABLE_OWNER FKTABLE_SCHEM, FKTABLE_NAME, FKCOLUMN_NAME, KEY_SEQ, 1 UPDATE_RULE,DELETE_RULE, FK_NAME, PK_NAME, 1 DEFERRABILITY FROM sysodbcforeignkeys ");
        stringBuffer.append("WHERE fktable_name = '" + string3 + "' ");
        if (this.realQualification(string2)) {
            stringBuffer.append("AND FKTABLE_OWNER = '" + string2 + "' ");
        }
        return this.internalQuery(stringBuffer.toString(), "getImportedKeys");
    }

    public ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT '' TABLE_CAT, table_owner TABLE_SCHEM, TABLE_NAME, decode (non_unique, 1, 'true', 'false') NON_UNIQUE, INDEX_QUALIFIER, INDEX_NAME, TYPE, seq_in_index ORDINAL_POSITION, COLUMN_NAME, collation ASC_OR_DESC, CARDINALITY, PAGES, FILTER_CONDITION FROM sysodbcindexes ");
        stringBuffer.append("WHERE INDEX_NAME <> 'SYSPRIMARYKEYINDEX' ");
        stringBuffer.append("AND table_name = '" + string3 + "' ");
        if (this.realQualification(string2)) {
            stringBuffer.append("AND table_owner = '" + string2 + "' ");
        }
        if (bl) {
            stringBuffer.append("AND non_unique = 0 ");
        }
        return this.internalQuery(stringBuffer.toString(), "getIndexInfo");
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        return 8000;
    }

    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }

    public int getMaxCharLiteralLength() throws SQLException {
        return 4000;
    }

    public int getMaxColumnNameLength() throws SQLException {
        return 32;
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        return 16;
    }

    public int getMaxColumnsInIndex() throws SQLException {
        return 16;
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        return 16;
    }

    public int getMaxColumnsInSelect() throws SQLException {
        return 254;
    }

    public int getMaxColumnsInTable() throws SQLException {
        return 254;
    }

    public int getMaxConnections() throws SQLException {
        try {
            ResultSet resultSet = this.connection.createStatement().executeQuery("select value from dbparameters    where description = 'MAXUSERTASKS'");
            resultSet.next();
            int n = resultSet.getInt(1);
            resultSet.close();
            return n;
        }
        catch (SQLException sQLException) {
            return 0;
        }
    }

    public int getMaxCursorNameLength() throws SQLException {
        return 32;
    }

    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    public int getMaxProcedureNameLength() throws SQLException {
        return 32;
    }

    public int getMaxRowSize() throws SQLException {
        return 0;
    }

    public int getMaxSchemaNameLength() throws SQLException {
        return 32;
    }

    public int getMaxStatementLength() throws SQLException {
        return this.connection.maxStatementLength();
    }

    public int getMaxStatements() throws SQLException {
        return Integer.MAX_VALUE;
    }

    public int getMaxTableNameLength() throws SQLException {
        return 32;
    }

    public int getMaxTablesInSelect() throws SQLException {
        return 16;
    }

    public int getMaxUserNameLength() throws SQLException {
        return 32;
    }

    public String getNumericFunctions() throws SQLException {
        return "ABS,ACOS,ASIN,ATAN,ATAN2,CEILING,COS,COT,DEGREES,EXP,FLOOR,LOG,LOG10,MOD,PI,POWER,RADIANS,ROUND,SIGN,SIN,SQRT,TAN,TRUNCATE";
    }

    public ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT '' TABLE_CAT, owner TABLE_SCHEM , tablename TABLE_NAME, columnname COLUMN_NAME, keypos KEY_SEQ, null PK_NAME FROM domain.columns ");
        stringBuffer.append("WHERE tablename = '" + string3 + "' ");
        if (this.realQualification(string2)) {
            stringBuffer.append("AND owner = '" + string2 + "' ");
        }
        stringBuffer.append("AND keypos is not null ");
        stringBuffer.append(" ORDER BY column_name ");
        return this.internalQuery(stringBuffer.toString(), "getPrimaryKeys");
    }

    public ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer.append("SELECT '' PROCEDURE_CAT, owner PROCEDURE_SCHEM, dbprocname PROCEDURE_NAME, parametername COLUMN_NAME, decode (\"IN/OUT-TYPE\", 'IN', 1, '   OUT', 2, 'IN/OUT', 4, 0) COLUMN_TYPE, decode (((decode (datatype,'CHAR','CHAR()','VARCHAR','VARCHAR()','LONG','LONG','LONG RAW','LONG',datatype))|| (' ' || (codetype))), 'CHAR', 1, 'CHAR() ASCII', 1, 'CHAR() EBCDIC', 1, 'CHAR() UNICODE', 1, 'CHAR() BYTE', -2, 'VARCHAR', 12, 'VARCHAR() ASCII', 12, 'VARCHAR() EBCDIC', 12, 'VARCHAR() UNICODE', 12, 'VARCHAR() BYTE', -3, 'LONG', -1, 'LONG ASCII', -1, 'LONG EBCDIC', -1, 'LONG UNICODE', -1, 'LONG BYTE', -4, 'LONG RAW', -4, 'FIXED', 3, 'DECIMAL', 3, 'REAL', 7, 'FLOAT', 6, 'DOUBLE PRECISION', 8, 'SMALLINT', 5, 'INTEGER', 4, 'BOOLEAN', -7, 'TIME', 92, 'DATE', 91, 'TIMESTAMP', 93, 'NUMBER', 2, 1111) DATA_TYPE, (decode(datatype,'CHAR','CHAR()','VARCHAR','VARCHAR()','LONG','LONG','LONG RAW','LONG',datatype))|| (' ' || (codetype)) TYPE_NAME, len PRECISION, len \"LENGTH\", dec SCALE, 10 RADIX, 2 NULLABLE, NULL REMARKS FROM domain.dbprocparams ");
        if (this.realPatternQualification(string2)) {
            stringBuffer2.append("AND owner like '" + string2 + "' ");
        }
        if (this.realPatternQualification(string3)) {
            stringBuffer2.append("AND dbprocname like '" + string3 + "' ");
        }
        if (this.realPatternQualification(string4)) {
            stringBuffer2.append("AND parametername like '" + string4 + "' ");
        }
        if (stringBuffer2.length() > 0) {
            stringBuffer.append("WHERE TRUE ");
            stringBuffer.append(stringBuffer2.toString());
        }
        stringBuffer.append("ORDER BY PROCEDURE_SCHEM, PROCEDURE_NAME, pos ");
        return this.internalQuery(stringBuffer.toString(), "getProcedureColumns");
    }

    public ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer.append("SELECT '' PROCEDURE_CAT, owner PROCEDURE_SCHEM, dbprocname PROCEDURE_NAME, NULL RESERVED4, NULL RESERVED5, NULL RESERVED6, comment REMARKS, 1 PROCEDURE_TYPE FROM domain.DBPROCEDURES ");
        if (this.realPatternQualification(string2)) {
            stringBuffer2.append("AND owner like '" + string2 + "' ");
        }
        if (this.realPatternQualification(string3)) {
            stringBuffer2.append("AND dbprocname like '" + string3 + "' ");
        }
        if (stringBuffer2.length() > 0) {
            stringBuffer.append("WHERE 1 = 1 ");
            stringBuffer.append(stringBuffer2.toString());
        }
        return this.internalQuery(stringBuffer.toString(), "getProcedures");
    }

    public String getProcedureTerm() throws SQLException {
        return "StoredProcedure";
    }

    public ResultSet getSchemas() throws SQLException {
        return this.internalQuery("Select username TABLE_SCHEM from domain.users  WHERE USERMODE <> 'COLDUSER' order by TABLE_SCHEM", "getSchemas");
    }

    public String getSchemaTerm() throws SQLException {
        return "SCHEM";
    }

    public String getSearchStringEscape() throws SQLException {
        return "\\";
    }

    public String getSQLKeywords() throws SQLException {
        return "ABS,ACOS,ADDDATE,ADDTIME,ALPHA,ASCII,ASIN,ATAN,ATAN2,BINARY,BOOLEAN,BYTE,CEIL,CEILING,CHR,CONCAT,CONNECTED,COS,COSH,COT,CURDATE,CURTIME,DATABASE,DATEDIFF,DAYNAME,DAYOFMONTH,DAYOFWEEK,DAYOFYEAR,DBYTE,DECODE,DEFAULT,DEGREES,DIGITS,DIRECT,EBCDIC,ENTRY,ENTRYDEF,EXP,EXPAND,FIXED,FLOOR,GRAPHIC,GREATEST,HEX,IFNULL,INITCAP,INT,INTERNAL,LCASE,LEAST,LENGTH,LFILL,LINK,LIST,LN,LOCALSYSDBA,LOCATE,LOG,LOG10,LONG,LPAD,LTRIM,MAKEDATE,MAKETIME,MAPCHAR,MBCS,MICROSECOND,MOD,MONTHNAME,NOROUND,NOW,NUM,OBJECT,PACKED,PI,POWER,PREV,RADIANS,REAL,REFERENCED,REJECT,REPLACE,RFILL,ROUND,ROWID,ROWNO,RPAD,RTRIM,SELUPD,SHOW,SIGN,SIN,SINH,SOUNDEX,SPACE,SQRT,STAMP,STATISTICS,STDDEV,SUBDATE,SUBSTR,SUBTIME,SYSDBA,TAN,TANH,TIMEDIFF,TIMEZONE,TOIDENTIFIER,TRIM,TRUNC,TRUNCATE,UCASE,UNICODE,USERGROUP,VARGRAPHIC,VARIANCE,WEEK,WEEKOFYEAR,ZONED";
    }

    public String getStringFunctions() throws SQLException {
        return "ASCII,CONCAT,LCASE,LEFT,LENGTH,LOCATE,LOCATE_2,LTRIM,REPLACE,RIGHT,RTRIM,SOUNDEX,SPACE,SUBSTRING,UCASE,ISNULL";
    }

    public String getSystemFunctions() throws SQLException {
        return "DBNAME,IFNULL,USERNAME";
    }

    public ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer.append("SELECT '' TABLE_CAT, OWNER TABLE_SCHEM, TABLENAME TABLE_NAME, GRANTOR, GRANTEE, PRIVILEGE, IS_GRANTABLE FROM domain.tableprivileges ");
        if (this.realPatternQualification(string2)) {
            stringBuffer2.append("AND owner LIKE '" + string2 + "' ");
        }
        if (this.realPatternQualification(string3)) {
            stringBuffer2.append("AND tablename LIKE '" + string3 + "' ");
        }
        if (stringBuffer2.length() > 0) {
            stringBuffer.append("WHERE 1 = 1 ");
            stringBuffer.append(stringBuffer2.toString());
        }
        stringBuffer.append(" ORDER BY owner, tablename ");
        return this.internalQuery(stringBuffer.toString(), "getTablePrivileges");
    }

    public ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT '' TABLE_CAT, owner TABLE_SCHEM, ");
        stringBuffer.append("tablename TABLE_NAME, type TABLE_TYPE, ");
        stringBuffer.append("comment REMARKS from domain.tables WHERE 1 = 1 ");
        if (this.realPatternQualification(string2)) {
            stringBuffer.append("AND owner LIKE '" + string2 + "' ");
        }
        if (this.realPatternQualification(string3)) {
            stringBuffer.append("AND tablename LIKE '" + string3 + "' ");
        }
        if (stringArray == null) {
            stringBuffer.append("AND type <> 'RESULT' ");
        } else if (stringArray != null && stringArray.length > 0) {
            stringBuffer.append("AND type in ('" + stringArray[0] + "'");
            int n = 1;
            while (n < stringArray.length) {
                stringBuffer.append(",'" + stringArray[n] + "'");
                ++n;
            }
            stringBuffer.append(") ");
        }
        stringBuffer.append("ORDER BY TABLE_TYPE, TABLE_SCHEM, TABLE_NAME");
        return this.internalQuery(stringBuffer.toString(), "getTables");
    }

    public ResultSet getTableTypes() throws SQLException {
        String[] stringArray = new String[]{"TABLE_TYPE"};
        Object[][] objectArray = new Object[][]{{"RESULT"}, {"SYNONYM"}, {"SYSTEM"}, {"TABLE"}, {"VIEW"}};
        MemoryResultSetSapDB memoryResultSetSapDB = new MemoryResultSetSapDB(stringArray, objectArray);
        return memoryResultSetSapDB;
    }

    public String getTimeDateFunctions() throws SQLException {
        return "CURDATE,CURTIME,DAYNAME,DAYOFMONTH,DAYOFWEEK,DAYOFYEAR,HOUR,MINUTE,MONTH,MONTHNAME,NOW,SECOND,WEEK,YEAR";
    }

    public ResultSet getTypeInfo() throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT TYPE_NAME, decode (TYPE_NAME, 'CHAR', 1, 'CHAR() ASCII', 1, 'CHAR() EBCDIC', 1, 'CHAR() UNICODE', 1, 'CHAR() BYTE', -2, 'VARCHAR', 12, 'VARCHAR() ASCII', 12, 'VARCHAR() EBCDIC', 12, 'VARCHAR() UNICODE', 12, 'VARCHAR() BYTE', -3, 'LONG', -1, 'LONG ASCII', -1, 'LONG EBCDIC', -1, 'LONG UNICODE', -1, 'LONG BYTE', -4, 'LONG RAW', -4, 'FIXED', 3, 'DECIMAL', 3, 'REAL', 7, 'FLOAT', 6, 'DOUBLE PRECISION', 8, 'SMALLINT', 5, 'INTEGER', 4, 'BOOLEAN', -7, 'TIME', 92, 'DATE', 91, 'TIMESTAMP', 93, 'NUMBER', 2, 1111) DATA_TYPE, PRECISION, LITERAL_PREFIX, LITERAL_SUFFIX, CREATE_PARAMS, NULLABLE, CASE_SENSITIVE, SEARCHABLE, UNSIGNED_ATTRIBUTE, money FIXED_PREC_SCALE , AUTO_INCREMENT, LOCAL_TYPE_NAME, MINIMUM_SCALE, MAXIMUM_SCALE, NULL SQL_DATA_TYPE , NULL SQL_DATETIME_SUB , 10 NUM_PREC_RADIX FROM sysodbctypes ");
        if (this.connection.isSQLModeOracle) {
            stringBuffer.append("WHERE TYPE_NAME NOT IN ('TIMESTAMP','TIME','BOOLEAN','FIXED') ");
        }
        stringBuffer.append("ORDER BY DATA_TYPE ");
        return this.internalQuery(stringBuffer.toString(), "getTypeInfo");
    }

    public ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws SQLException {
        return new MemoryResultSetSapDB(new String[]{"TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "CLASS_NAME", "DATA_TYPE", "REMARKS", "BASE_TYPE"}, new Object[0][]);
    }

    public String getURL() throws SQLException {
        return this.connection.getConnectProperty("dburl");
    }

    public String getUserName() throws SQLException {
        return this.connection.getConnectProperty("user");
    }

    public ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        return new MemoryResultSetSapDB(new String[]{"SCOPE", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "PSEUDO_COLUMN"}, new Object[0][]);
    }

    public boolean insertsAreDetected(int n) throws SQLException {
        return false;
    }

    private ResultSet internalQuery(String string, String string2) throws SQLException {
        ResultSet resultSet;
        Tracer.println("<Internal Query routine=" + string2 + " >\n" + string + "\n</Internal Query>\n");
        try {
            resultSet = this.connection.createStatement().executeQuery(string);
            try {
                ((ResultSetSapDB)resultSet).setFromMetaData(true);
            }
            catch (ClassCastException classCastException) {}
        }
        catch (DatabaseException databaseException) {
            throw new InternalJDBCError(string2, databaseException);
        }
        return resultSet;
    }

    public boolean isCatalogAtStart() throws SQLException {
        return false;
    }

    public boolean isReadOnly() throws SQLException {
        return false;
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedLow() throws SQLException {
        return true;
    }

    public boolean othersDeletesAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean othersInsertsAreVisible(int n) throws SQLException {
        return true;
    }

    public boolean othersUpdatesAreVisible(int n) throws SQLException {
        return true;
    }

    public boolean ownDeletesAreVisible(int n) throws SQLException {
        return true;
    }

    public boolean ownInsertsAreVisible(int n) throws SQLException {
        return true;
    }

    public boolean ownUpdatesAreVisible(int n) throws SQLException {
        return true;
    }

    private boolean realPatternQualification(String string) {
        if (string == null) {
            return false;
        }
        if (string.length() == 0) {
            return false;
        }
        return !string.equals("*");
    }

    private boolean realQualification(String string) {
        if (string == null) {
            return false;
        }
        return string.length() != 0;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return true;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    public boolean supportsConvert() throws SQLException {
        return false;
    }

    public boolean supportsConvert(int n, int n2) throws SQLException {
        return false;
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return true;
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return false;
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return false;
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        return true;
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return true;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return true;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return true;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return true;
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        return false;
    }

    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsPositionedDelete() throws SQLException {
        return true;
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        return true;
    }

    public boolean supportsResultSetConcurrency(int n, int n2) throws SQLException {
        switch (n) {
            case 1003: 
            case 1004: 
            case 1005: {
                break;
            }
            default: {
                throw new InvalidArgumentValue("resultSetType", "TYPE_FORWARD_ONLY, TYPE_SCROLL_INSENSITIVE, TYPE_SCROLL_SENSITIVE");
            }
        }
        switch (n2) {
            case 1007: 
            case 1008: {
                break;
            }
            default: {
                throw new InvalidArgumentValue("resultSetConcurrency", "CONCUR_READ_ONLY, CONCUR_UPDATABLE");
            }
        }
        return true;
    }

    public boolean supportsResultSetType(int n) throws SQLException {
        switch (n) {
            case 1003: 
            case 1004: 
            case 1005: {
                break;
            }
            default: {
                throw new InvalidArgumentValue("resultSetType", "TYPE_FORWARD_ONLY, TYPE_SCROLL_INSENSITIVE, TYPE_SCROLL_SENSITIVE");
            }
        }
        return true;
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        return true;
    }

    public boolean supportsStoredProcedures() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    public boolean supportsTransactionIsolationLevel(int n) throws SQLException {
        return n != 0;
    }

    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    public boolean supportsUnion() throws SQLException {
        return true;
    }

    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    public boolean updatesAreDetected(int n) throws SQLException {
        return false;
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    public boolean supportsSavepoints() throws SQLException {
        return true;
    }

    public boolean supportsNamedParameters() throws SQLException {
        return true;
    }

    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    public boolean supportsGetGeneratedKeys() throws SQLException {
        return false;
    }

    public ResultSet getSuperTypes(String string, String string2, String string3) throws SQLException {
        return new MemoryResultSetSapDB(new String[]{"TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "SUPERTYPE_CAT", "SUPERTYPE_SCHEM", "SUPERTYPE_NAME"}, new Object[0][]);
    }

    public ResultSet getSuperTables(String string, String string2, String string3) throws SQLException {
        return new MemoryResultSetSapDB(new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "SUPERTABLE_NAME"}, new Object[0][]);
    }

    public ResultSet getAttributes(String string, String string2, String string3, String string4) throws SQLException {
        return new MemoryResultSetSapDB(new String[]{"TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "ATTR_NAME", "DATA_TYPE", "ATTR_TYPE_NAME", "ATTR_SIZE", "DECIMAL_DIGITS", "NUM_PREC_RADIX", "NULLABLE", "REMARKS", "ATTR_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE", "SCOPE_CATALOG", "SCOPE_SCHEMA", "SCOPE_TABLE", "SOURCE_DATA_TYPE"}, new Object[0][]);
    }

    public boolean supportsResultSetHoldability(int n) throws SQLException {
        return true;
    }

    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    public int getDatabaseMajorVersion() throws SQLException {
        return this.dbVersionInfo.getMajorVersion();
    }

    public int getDatabaseMinorVersion() throws SQLException {
        return this.dbVersionInfo.getMinorVersion();
    }

    public int getJDBCMajorVersion() throws SQLException {
        return 3;
    }

    public int getJDBCMinorVersion() throws SQLException {
        return 0;
    }

    public int getSQLStateType() throws SQLException {
        return 2;
    }

    public boolean locatorsUpdateCopy() throws SQLException {
        return false;
    }

    public boolean supportsStatementPooling() throws SQLException {
        return this.connection.parseCache != null;
    }
}

