
/**************************************************************************
 *                                                                        *
 *  BTools - Miscellaneous Java utility classes                           *
 *                                                                        *
 *  Copyright (c) 1998-2001, Ben Burton                                   *
 *  For further details contact Ben Burton (benb@acm.org).                *
 *                                                                        *
 *  This program is free software; you can redistribute it and/or         *
 *  modify it under the terms of the GNU General Public License as        *
 *  published by the Free Software Foundation; either version 2 of the    *
 *  License, or (at your option) any later version.                       *
 *                                                                        *
 *  This program is distributed in the hope that it will be useful, but   *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *  General Public License for more details.                              *
 *                                                                        *
 *  You should have received a copy of the GNU General Public             *
 *  License along with this program; if not, write to the Free            *
 *  Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,        *
 *  MA 02111-1307, USA.                                                   *
 *                                                                        *
 **************************************************************************/

/* end stub */

package org.gjt.btools.gui.lookandfeel;

import java.awt.*;
import javax.swing.*;

/**
 * Provides information about a particular swing look and feel in a way
 * that makes it suitable for use in menus.
 * In particular, the <tt>toString()</tt> method returns a user-friendly
 * description of the look and feel.
 * <p>
 * The static function <tt>getInstalledLookAndFeels</tt> will produce
 * a list of all available look and feels.
 *
 * @see #getInstalledLookAndFeels
 */
public class LookAndFeelItem {
    /**
     * Information about this look and feel.
     */
    private UIManager.LookAndFeelInfo info;

    /**
     * Create a new look and feel item based on the given information.
     *
     * @info information about the look and feel which the new object
     * will represent.
     */
    public LookAndFeelItem(UIManager.LookAndFeelInfo info) {
        this.info = info;
    }

    /**
     * Return the name of the Java look and feel class that this
     * object represents.
     *
     * @return the name of the corresponding Java look and feel class.
     */
    public String getClassName() {
        return info.getClassName();
    }

    /**
     * Sets the current look and feel to the look and feel represented
     * by this object.  No error messages will be displayed to the user.
     * Note that <tt>updateLookAndFeel</tt> must then be run on each top-level
     * container.
     *
     * @return <tt>true</tt> if and only if the look and feel was
     * successfully changed.
     * @see #updateLookAndFeel
     */
    public boolean setLookAndFeel() {
        try {
            UIManager.setLookAndFeel(info.getClassName());
        } catch (Throwable th) {
            return false;
        }
        return true;
    }

    /** 
     * Update the given container and all components contained therein
     * to reflect the currently installed look and feel.
     *
     * @param topLevelContainer the container to update.
     */
    public static void updateLookAndFeel(Frame topLevelContainer) {
        SwingUtilities.updateComponentTreeUI(topLevelContainer);
    }

    /**
     * Returns a user-friendly description of this look and feel.
     * This string can be used to identify this look and feel in a
     * menu, combo box or similar component.
     *
     * @return a description of this look and feel.
     */
    public String toString() {
        return info.getName();
    }

    /**
     * Returns a list of all available look and feels.
     *
     * @return an array containing information about all available
     * look and feels.
     */
    public static LookAndFeelItem[] getInstalledLookAndFeels() {
        UIManager.LookAndFeelInfo[] items =
            UIManager.getInstalledLookAndFeels();
        int total = items.length;
        LookAndFeelItem[] result = new LookAndFeelItem[total];
        for (int i=0; i<total ; i++)
            result[i] = new LookAndFeelItem(items[i]);
        return result;
    }
}

