;;; -*- Mode: Lisp; Package: cl-user -*-
;;;;
;;;; This is part of the acl-installer program: 
;;;;    http://kevin.rosenberg.net/acl-installer
;;;; Copyright (c) 2002 Kevin M. Rosenberg
;;;;
;;;;  This program is free software; you can redistribute it and/or modify
;;;;  it under the terms of the GNU General Public License (version 2) as
;;;;  published by the Free Software Foundation.
;;;;
;;;;  This program is distributed in the hope that it will be useful,
;;;;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;;;  GNU General Public License for more details.
;;;;
;;;;  Should should have a copy of the GNU General Public License on your
;;;;  Debian system in the file /usr/share/common-licenses/GPL-2


;; set unique fasl

(eval-when (:compile-toplevel :load-toplevel :execute)
  (if (or (eq excl:*current-case-mode* :case-sensitive-lower)
	  (eq excl:*current-case-mode* :case-sensitive-upper))
      (pushnew :case-sensitive common-lisp:*features*)
    (pushnew :case-insensitive common-lisp:*features*)))

(let ((my-fasl-type
       #+(and allegro ics case-sensitive) "faslm16"
       #+(and allegro (not ics) case-sensitive) "faslm8"
       #+(and allegro ics (not case-sensitive)) "fasla16"
       #+(and allegro (not ics) (not case-sensitive)) "fasla8"))
  (progn (setq *fasl-default-type* my-fasl-type)
	 (setq sys:*load-search-list*
	       (list #p"" (make-pathname :type my-fasl-type)
		     #p(:type "cl") #p(:type "lisp")))))



