#include <vector>
#include <string>
#include <sstream>
#include <iostream>
#include <iomanip>

#include <time.h>
#include <gtkmm/treeview.h>
#include <gtkmm/treemodel.h>

using namespace std;

#include "gtktracklist.h"
#include "preferences.h"
#include "facontext.h"
#include "gtkmusicbrowser.h"
#include "error.h"

GTKLibrary::GTKTrackList::GTKTrackList(GTKLibrary *library)
	: GTKLibraryList(library)
{
	set_list_model_columns(&m_TrackCols);
}

void GTKLibrary::GTKTrackList::set_list_columns()
{
	std::string cols;
	bool finished = false;
	unsigned int startPos, endPos;
	Gtk::TreeView::Column* addedCol;
	
	//Reset Columns
	m_listMusic.remove_all_columns();
	m_context->prefs->GetPrefString(kPlaylistHeaderColumnsPref, cols);
	
	m_listMusic.append_column("", m_TrackCols.icon);
	
	//Parse Prefrence String
	startPos = 0;
	int addedcolindex = 1;
	while(!finished) {
		std::string Column;
		
		//Get Next Column
		endPos = cols.find("|", startPos);
		if(endPos == string::npos) {
			endPos = cols.length();
			finished = true;
		}
		Column = cols.substr(startPos, endPos - startPos);
		
		//Add Next Column
		if(Column == "Artist")
			m_listMusic.append_column("Artist", m_TrackCols.artist);
		else if(Column == "Album")
			m_listMusic.append_column("Album", m_TrackCols.album);
		else if(Column == "Comment")
			m_listMusic.append_column("Comment", m_TrackCols.comment);
		else if(Column == "Genre")
			m_listMusic.append_column("Genre", m_TrackCols.genre);
		else if(Column == "Location")
			m_listMusic.append_column("Location", m_TrackCols.location);
		else if(Column == "Title")
			m_listMusic.append_column("Title", m_TrackCols.title);
		else if(Column == "Time")
			m_listMusic.append_column("Time", m_TrackCols.time);
		else if(Column == "Track")
			m_listMusic.append_column("Track", m_TrackCols.track);
		else if(Column == "Year")
			m_listMusic.append_column("Year", m_TrackCols.year);
		
		addedCol = m_listMusic.get_column(addedcolindex);
		if(addedCol) {
			addedCol->set_resizable();
			addedcolindex++;
		}
		startPos = endPos + 1;
	}
}

void GTKLibrary::GTKTrackList::set_rows_data(std::vector<Gtk::TreeModel::Path> RowPaths)
{
	std::vector<Gtk::TreeModel::Path>::iterator visible_path;
	
	//Set Data For Paths
	for(visible_path = RowPaths.begin(); visible_path != RowPaths.end(); visible_path++) {
		//Get Info
		Gtk::TreeModel::Row visible_row = *(m_listmodelMusic->get_iter(*visible_path));
		if((visible_row[m_TrackCols.last_refresh] < m_library->m_last_change) || (visible_row[m_TrackCols.last_refresh] < last_parent_change)) {
			//PlaylistItem *Track = visible_row[m_TrackCols.MusicCatalogItem];
			CatalogInfo *Track = m_parent->child_item((*visible_path).back());
			Metadata& md = Track->item_info();
			
			//Show Info

			visible_row[m_TrackCols.icon] = Track->item_icon();
			visible_row[m_TrackCols.location] = Track->item_url();

			visible_row[m_TrackCols.artist] = md[Metadata::kArtist];
			visible_row[m_TrackCols.album] = md[Metadata::kAlbum];
			visible_row[m_TrackCols.comment] = md[Metadata::kComment];
			visible_row[m_TrackCols.genre] = md[Metadata::kGenre];
			visible_row[m_TrackCols.title] = md[Metadata::kTitle];
			
			//Represent Time
			int32_t Minutes, Seconds, Total;
            md.getTag(Metadata::kTime, Total);

			ostringstream sTime;
            string text;
			if(Total > 0) {
				Seconds = Total % 60;
				Minutes = Total / 60;
				sTime << Minutes << ":" << setw(2) << setfill('0') << Seconds;
			} else
				sTime << "-";
			visible_row[m_TrackCols.time] = sTime.str();
			
			//Represent Track Number
            if (md.hasKey(Metadata::kTrack)) {
                text = md[Metadata::kTrack];
            } else {
                text = "-";
            }
			visible_row[m_TrackCols.track] = text;
			
			//Represent Year
            text.clear();
            if (md.hasKey(Metadata::kYear)) {
                text = md[Metadata::kYear];
            } else {
                text = "-";
            }
			visible_row[m_TrackCols.year] = text;
			visible_row[m_TrackCols.last_refresh] = time(NULL);
			
			//Delete Temp Info
			delete Track;
		}
	}
}

void GTKLibrary::GTKTrackList::init_row(Gtk::TreeModel::Row& new_row)
{
	new_row[m_TrackCols.last_refresh] = 0;
}
/* arch-tag: 8ee75189-a7b0-455a-82bb-30c766a557e2 */
