/*____________________________________________________________________________
	
	Zinf - Zinf Is Not FreeA*p (The Free MP3 Player)

	Portions Copyright (C) 1999 EMusic.com

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
	
	$Id: Icecast.h,v 1.4 2003/09/16 17:35:28 kgk Exp $
____________________________________________________________________________*/

#ifndef INCLUDED_ICECAST_H
#define INCLUDED_ICECAST_H

#include <string>
#include <vector>


#include <assert.h>

#include "config.h"
#include "errors.h"
#include "Parse.h"

struct IcecastStreamInfo
{
    std::string m_streamUrl;
    std::string m_name;
    std::string m_webUrl;
    std::string m_eMail;
    std::string m_desc;
    int    m_bitrate;
};

/*

The data will look like this:
<directory>
    <resource href="http://icecast.server.com:8000/stream">
       <bitrate>64000</bitrate>
       <name>Some stream</name>
       <url>http://www.icecast.org</url>
       <email>jack@icecast.org</email>
       <description>This is some description</description>
    </resource>
</directory>

And it should be available at:

http://yp.icecast.org/yplist_long.xml 

*/

class IcecastStreams : public Parse 
{
 public:
             IcecastStreams(void);
    virtual ~IcecastStreams(void);

       Error ParseStreamXML(const std::string &xml, 
                            std::vector<IcecastStreamInfo> &list);

 protected:
 
       Error BeginElement(std::string &oElement, AttrMap &oAttrMap);
       Error EndElement(std::string &oElement);
       Error PCData(std::string &oData);

 private:
 
     std::string                     m_path;
     IcecastStreamInfo         *m_info;
     std::vector<IcecastStreamInfo> *m_list;
};

#endif // INCLUDED_RMP_H

/* arch-tag: 882ae086-9f2d-49c7-820c-fcec3e370ca7
   (do not change this comment) */
