/* -*- c++ -*-________________________________________________________________
 
        Zinf - Zinf Is Not FreeA*p (The Free MP3 Player)

        Portions Copyright (C) 1999 EMusic.com

        This program is free software; you can redistribute it and/or modify
        it under the terms of the GNU General Public License as published by
        the Free Software Foundation; either version 2 of the License, or
        (at your option) any later version.

        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with this program; if not, write to the Free Software
        Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

        $Id: filemetadb.cpp,v 1.2 2003/09/29 02:29:46 kgk Exp $
 ____________________________________________________________________________*/

#include <unistd.h>

using namespace std;

#include "errors.h"
#include "utility.h"
#include "filemetadb.h"

#if 0
// Should be done on a tag by tag basis.

/**
 * Remove preceding/trailing space and squeeze all intervening
 * spaces to 1
 */
static string squeeze_space (const string& s) {
    string ns = s;
    string::size_type pos=0;
    for (;;) {
        pos = ns.find (' ', pos);
        if (pos == string::npos) break;
        string::size_type count = 0;
        while (ns[pos+count] == ' ') count++;
        if (count > 1)
            ns.erase (pos, count-1);
        pos++;
    }
    if (ns[0] == ' ') ns.erase(0);
    if (ns[ns.size()-1] == ' ') ns.erase(ns.size()-1);

    return ns;
}
#endif


FileMetadataDB::FileMetadataDB(PlaylistManager*plm)
    : MetadataDB(), m_plm(plm)
{
}

FileMetadataDB::~FileMetadataDB()
{
}

bool
FileMetadataDB::add(const url_t& url, const Metadata&m)
{
    log("FileMetadataDB::add");
    // Ignore
    return false;
}

bool
FileMetadataDB::remove(const url_t&url)
{
    // Ignore
    return false;
}

bool
FileMetadataDB::contains(const url_t&url)
{
    string path;
    URLToFilePath(url, path);

    return access(path.c_str(), R_OK)==0;
}


bool FileMetadataDB::getMetadata(const url_t&url, Metadata&m)
{
    // Super UGLY hack while code is being restructured.
    // Currently the metadata file parsers are only loaded
    // in the playlistmanager.  We need to ask the manager
    // to actually read the data.  Eventually the manager
    // should ask the MusicCatalog to manage the reading.
    log("FileMetadataDB::getMetadata");


    MetaDataFormat::map_type map;
    MetaDataFormat::map_type::iterator tags;
    
    if (m_plm->readMetadataFile(url, map)) {
        m.clear();
        for (tags = map.begin(); tags!= map.end(); tags++) {
            m.insert(*tags);
            //log(string("tagging ") + (*tags).first + ':' + (*tags).second);
        }
        //log(string("Read metadata:")+(string)m);
        return true;
    }
    return false;
}

bool FileMetadataDB::setMetadata(const url_t&url, const Metadata&m)
{
    if (!m_writesOK) return false;


    string path;
    URLToFilePath(url, path);

    string::size_type pos;
    pos = path.rfind('.');

    if (access(path.c_str(), R_OK|W_OK)!=0) 
        return false;
    MetaDataFormat::map_type map;

    //copy(m.begin(), m.end(), insert_iterator(map, map.end()));
    //m_plm->writeMetadataFile(url, map);

    return true;
}



/* arch-tag: fd7eecf7-3f9a-4b41-84a8-0ec2cc26599a */
