#ifndef YTYPES_H
#define YTYPES_H

#include <limits.h>
#include <sys/types.h>

/* Include header file for libY2 that comes with this distribution,
 * this is to define major and minor op codes for network parsing.
 */
#include "../include/Y2/Y.h"


/*
 *	Sound buffer type:
 */
typedef char SoundBuffer;

/*
 *	Permissions:
 */
typedef int AccessLevel;
typedef unsigned short YPermission;

/*
 *	Client connection number type:
 */
typedef int YConnectionNumber;

/*
 *	Play stack ID type:
 */
typedef YID PlayStackID;

/*
 *	Volume structure.
 */
typedef struct {

	/* Coefficient = (val / ((u_int16_t)-1)) */

	u_int16_t	left, right,
			back_left, back_right;

} YVolumeStruct;


#endif	/* YTYPES_H */
