
#include "hdri.h"

using namespace std;

__BEGIN_YAFRAY

HDRI_Background_t::HDRI_Background_t(const char* fname, int expadj, bool mp)
{
  img = new HDRimage_t();
  if (!img->LoadHDR(fname, HDR_RGBE)) {
    cout << "Error, HDRI_Background_t(): could not load " << fname << endl;
    delete img;
    img = NULL;
  }
  else {
    img->setExposureAdjust(expadj);
    cout << "HDR image " << fname << " load ok.\n";
    mapProbe = mp;
  }
}


HDRI_Background_t::~HDRI_Background_t()
{
  if (img) {
    delete img;
    img = NULL;
  }
}

// convert direction to uv and get color from HDR image
color_t HDRI_Background_t::operator() (const vector3d_t &dir,renderState_t &state) const
{
  if (img==NULL) return color_t(0.0);
  PFLOAT u=0, v=0;
  // need transform, currently y & z swap to conform to Blender axes
  if (mapProbe) {
    PFLOAT r = dir.x*dir.x + dir.z*dir.z;
    if (r!=0.f)  {
      r = 1.f/sqrt(r);
      if (dir.y>1.f)
        r = 0;
      else if (dir.y>=-1.f)
        r *= M_1_PI * acos(dir.y);
    }
    if ((u = 0.5f - 0.5f*dir.x*r) < 0.f) u = 0.f; else if (u > 1.f) u = 1.f;
    if ((v = 0.5f + 0.5f*dir.z*r) < 0.f) v = 0.f; else if (v > 1.f) v = 1.f;
  }
  else {
    // currently only other possible type is sphere
    spheremap(dir, u, v);
    // v is upside down in this case
    v = 1.0-v;
  }
  return img->BilerpSample(u, v);
}

background_t *HDRI_Background_t::factory(paramMap_t &params,renderEnvironment_t &render)
{
  string _filename;
  int expadj = 0;	// changes actual pixel exponent, can be negative
  string _mapping = "probe";
	
	const string *filename=&_filename,*mapping=&_mapping; // ask jandro about msvc hell
	
  params.getParam("exposure_adjust", expadj);
  params.getParam("filename", filename);
  params.getParam("mapping", mapping);
  // two mapping types only at the moment, probe or sphere
  bool mapprobe = (*mapping=="probe");
  if (*filename=="") {
    cerr<< "(background_HDRI) Error,  No filename given\n";
    return NULL;
  }
  return new HDRI_Background_t(filename->c_str(), expadj, mapprobe);
}

extern "C"
{
	
YAFRAYPLUGIN_EXPORT void registerPlugin(renderEnvironment_t &render)
{
	render.registerFactory("HDRI",HDRI_Background_t::factory);
	
	std::cout<<"Registered HDRI background\n";
}

}
__END_YAFRAY
