/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef AUDIOCONFIG_H
#define AUDIOCONFIG_H

class AudioConfig
{

 public:

    // Configuration constants.
    enum
    {
         MONO = 1,
         STEREO = 2,
         BITS_8 = 8,
         BITS_16 = 16,
         SIGNED_PCM = 0x7f,
         UNSIGNED_PCM = 0x80
    };
    
    
    int frequency;
    int precision;
    int channels;
    int encoding;

    int bufSize;       // sample buffer size
    
    // Special!
    int maxFrags;
    int fragSize;
    int blockSize;     // run-time only

    AudioConfig()
    {
        frequency = 22050;
        precision = BITS_8;
        channels = MONO;
        encoding = UNSIGNED_PCM;
        bufSize = 4096;
        maxFrags = 32;
        fragSize = 1024;
        blockSize = 0;
    }

  const bool operator==(const AudioConfig& a) const
  {
    return frequency == a.frequency
      && precision == a.precision
      && channels == a.channels
      && encoding == a.encoding
      && maxFrags == a.maxFrags
      && fragSize == a.fragSize
      && blockSize == a.blockSize
      ;
  }

};

#endif  /* AudioConfig_h */
