/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2003 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __SINGIT_KARAOKE_DATA_H__
#define __SINGIT_KARAOKE_DATA_H__

#include <glib.h>
#include <gdk/gdktypes.h>
#include <gtk/gtk.h>

#include <singit/song.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define TYPE_SINGIT_KARAOKE_DATA            (singit_karaoke_data_get_type ())
#define SINGIT_KARAOKE_DATA(obj)            (GTK_CHECK_CAST ((obj), TYPE_SINGIT_KARAOKE_DATA, SingitKaraokeData))
#define SINGIT_KARAOKE_DATA_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), TYPE_SINGIT_KARAOKE_DATA, SingitKaraokeData))
#define IS_SINGIT_KARAOKE_DATA(obj)         (GTK_CHECK_TYPE ((obj), TYPE_SINGIT_KARAOKE_DATA))
#define IS_SINGIT_KARAOKE_DATA_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TYPE_SINGIT_KARAOKE_DATA))

typedef struct _SingitKaraokeData         SingitKaraokeData;
typedef struct _SingitKaraokeDataClass    SingitKaraokeDataClass;
typedef struct _StrLineInfo               StrLineInfo;

enum {
	SKD_EXPOSE_ALL = 1 << 0,
	SKD_EXPOSE_PROGRESS = 1 << 1,
	SKD_EXPOSE_BALL = 1 << 2,
	SKD_EXPOSE_TIMELINE = 1 << 3
};

struct _StrLineInfo {

	gchar    *text;		// Pointer to the text line (not freed!)
	gint      str_len;	// Length of the line (charactes)
	gint      str_pixel;	// Length of the line (pixel)

	gint     *word_pixel;	// The length of every word [words]
	gint     *space_pixel;	// The length of the space between words [words-1]
	gint     *start_pixel;	// Length from the start to the end of any word [words]

	gdouble  *jump_radius;  // The radius and angle define a part of a
	gdouble  *jump_angle;	// circle from one word to the next
};

struct _SingitKaraokeData
{
	GtkObject    object;

	// "Semi"-constant calculated widget values

	// Longest line in pixel (depends on the font and song)
	gint max_line_nr;
	gint max_line_pixel;

	// The ball diameter
	gint ball_diameter;
	// The height of the ball line
	gint ball_line_height;
	// The height of a text line
	gint text_line_height;
	// Left offset of the text in a line
	gint text_left_offset;
	// Minimal height of a visual to display the full widget
	gint visual_min_height;
	// Minimal width of a visual to display the full widget
	gint visual_min_width;
	// Heigth of the top lines
	gint top_lines_height;

	// Progress bar positions (pbp)
	guint           pbp_start, pbp_offset, pbp_offset_max;
	guint           pbp_start_last, pbp_offset_last;

	// Ball y positions
	guint           ball_y_pos, ball_y_pos_last;
	guint           ball_start, ball_offset_max;

	StrLineInfo    *line_info;

	// Attached current song
	SingitSong     *song;
	// Represents the current token
	GList          *current;

	gint            last_time;

	guint           line_seperator_high;
	guint           active_line_seperator_high;

	gint            freezers;
	gint            thaw_refresh;

	gint            line_offset;

	gpointer        font;
	gint            font_heigth;

	// Optimize font data
	gint            drawing_area_width;
	gint            drawing_area_height;

	// Options
	gboolean        centerLines;
	gboolean        use_ball;
	gboolean        show_empty_lines;
	gboolean        optimize_font;

	guint           lines;
	guint           top_lines;
};

struct _SingitKaraokeDataClass
{
	GtkObjectClass parent_class;

	// This callback has to be connected to the funtion,
	// which can calculate the length of a text dependant on the font
	gint      (* render)      (SingitKaraokeData *skd, gpointer font, gchar* text);

	// This callback should return a font object,
	// which fits the text the best into the given space
	gpointer  (* optimize)    (SingitKaraokeData *skd, gint x, gint y, gchar* text);

	gboolean  (* expose)      (SingitKaraokeData *skd, GdkRectangle *area, gint event, gint time);
	void      (* new_ball)    (SingitKaraokeData *skd, gint wxy);
	void      (* new_visual)  (SingitKaraokeData *skd, gint wx, gint wy);
};

GtkType    singit_karaoke_data_get_type                  (void);
GtkObject *singit_karaoke_data_new                       (void);

void       singit_karaoke_data_freeze                    (SingitKaraokeData *skd);
void       singit_karaoke_data_thaw                      (SingitKaraokeData *skd);

void       singit_karaoke_data_set_song                  (SingitKaraokeData *skd, SingitSong *new_song);
void       singit_karaoke_data_set_time                  (SingitKaraokeData *skd, guint time);

// Get / Set number of lines
void       singit_karaoke_data_set_lines                 (SingitKaraokeData *skd, guint value);
guint      singit_karaoke_data_get_lines                 (SingitKaraokeData *skd);

// Get / Set number of lines over the "active" one
// The number has to be smaller then lines
void       singit_karaoke_data_set_toplines              (SingitKaraokeData *skd, guint value);
guint      singit_karaoke_data_get_toplines              (SingitKaraokeData *skd);

// Get / Set centered lines
void       singit_karaoke_data_set_centered_lines        (SingitKaraokeData *skd, gboolean value);
gboolean   singit_karaoke_data_get_centered_lines        (SingitKaraokeData *skd);

void       singit_karaoke_data_set_font                  (SingitKaraokeData *skd, const gpointer font, gint font_heigth);
void       singit_karaoke_data_set_show_empty_lines      (SingitKaraokeData *skd, const gboolean value);
void       singit_karaoke_data_set_jumping_ball          (SingitKaraokeData *skd, const gboolean value);

// Calculate optimal font size
void       singit_karaoke_data_set_optimize_font          (SingitKaraokeData *skd, gboolean optimize);
gboolean   singit_karaoke_data_get_optimize_font          (SingitKaraokeData *skd);
// This function executes the font optimization process manually
void       singit_karaoke_data_optimize_font              (SingitKaraokeData *skd);
// * This has to be called with the size of the drawing area size
// * of the widget, otherwise optimization can't work
void       singit_karaoke_data_set_drawing_area           (SingitKaraokeData *skd, gint w, gint h);

gint       singit_karaoke_data_get_line_offset            (SingitKaraokeData *skd, gboolean ball);
gint       singit_karaoke_data_calc_line_offset           (SingitKaraokeData *skd, gboolean ball, gchar *text);
/*
void       singit_karaoke_data_get_timeline_times        (SingitKaraokeData *skd, gint *start, gint* max, gint* offset);
*/
#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif  // __SINGIT_KARAOKE_DATA_H__
