/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2003 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


// *A sub class of SingitConfigGen, which implements the open and close
// * funtions for XMMS ConfigFile

#ifndef __SINGIT_CONFIG_XMMS_H__
#define __SINGIT_CONFIG_XMMS_H__

#include <singit/config_gen.h>

#include <xmms/configfile.h>

#ifdef __cplusplus
extern "C" {
#endif // * __cplusplus *

#define TYPE_SINGIT_CONFIG_XMMS            (singit_config_xmms_get_type ())
#define SINGIT_CONFIG_XMMS(obj)            (GTK_CHECK_CAST ((obj), TYPE_SINGIT_CONFIG_XMMS, SingitConfigXMMS))
#define SINGIT_CONFIG_XMMS_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), TYPE_SINGIT_CONFIG_XMMS, SingitConfigXMMS))
#define IS_SINGIT_CONFIG_XMMS(obj)         (GTK_CHECK_TYPE ((obj), TYPE_SINGIT_CONFIG_XMMS))
#define IS_SINGIT_CONFIG_XMMS_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TYPE_SINGIT_CONFIG_XMMS))

typedef struct _SingitConfigXMMS       SingitConfigXMMS;
typedef struct _SingitConfigXMMSClass  SingitConfigXMMSClass;

struct _SingitConfigXMMS
{
	SingitConfigGen       scg;
};

struct _SingitConfigXMMSClass
{
	SingitConfigGenClass  parent_class;
};

GtkType            singit_config_xmms_get_type (void);
SingitConfigGen*   singit_config_xmms_new      (void);

void        xmms_cfg_write_del_string
	(ConfigFile *cfg, gchar *section, gchar* entry, gchar *value);

gboolean    xmms_cfg_read_color
	(ConfigFile *cfg, gchar *section, gchar *key, gchar **color_str);

// Convenience macros to prevent compiler complains
#define singit_config_xmms_read(type, cfg, section, key, value) \
	xmms_cfg_read_##type(cfg, (gchar*) section, (gchar*) key, value)

#define singit_config_xmms_write(type, cfg, section, key, value) \
	xmms_cfg_write_##type(cfg, (gchar*) section, (gchar*) key, value)

#define singit_config_xmms_remove_key(cfg, section, key) \
	xmms_cfg_remove_key(cfg, (gchar*) section, (gchar*) key)


// *  The following macros help to get config values
// *  You have to define the following values to use them
// *
// * If you use the *_GBL macro:
// *
// * #define GBL_VAR		global
// * #define GBL_SESSION 		sessionid
// *
// * For the other functions these macros are enough:
// *
// * #define CFG_DATA		cfg_data
// * #define CFG_FILE		cfg_file
// * #define SECTION		"Global"

#define READ_CFG_DEF(type,val,def) \
do { \
	if (!singit_config_xmms_read(type, CFG_FILE, SECTION, #val, &(CFG_DATA->val))) \
		{ CFG_DATA->val = def; } \
} while (0)

#define READ_CFG_DEF_CAST(type,val,def) \
do { \
	if (!singit_config_xmms_read(type, CFG_FILE, SECTION, #val, (type*) &(CFG_DATA->val))) \
		{ CFG_DATA->val = def; } \
} while (0)

#define READ_CFG_DEF_GBL(type,val,cfg_func) \
do { \
	if (CFG_DATA->GBL_VAR || !singit_config_xmms_read(type, CFG_FILE, SECTION, #val, &(CFG_DATA->val))) \
		{ CFG_DATA->val = singit_remote_cfg_##cfg_func(GBL_SESSION); } \
} while (0)

#define READ_CFG_DEF_GBL_ARG(type,val,cfg_func,args) \
do { \
	if (CFG_DATA->GBL_VAR || !singit_config_xmms_read(type, CFG_FILE, SECTION, #val, &(CFG_DATA->val))) \
		{ CFG_DATA->val = singit_remote_cfg_##cfg_func(GBL_SESSION, args); } \
} while (0)


#define WRITE_CFG(type,val) \
do { \
	singit_config_xmms_write(type, CFG_FILE, SECTION, #val, CFG_DATA->val); \
} while (0)

#ifdef __cplusplus
}
#endif // * __cplusplus *

#endif  // __SINGIT_CONFIG_XMMS_H__
