
#ifndef _C_EG_FILE_SPEC_H__
#define _C_EG_FILE_SPEC_H__

#include "UtilStr.h"
#include "CEgErr.h"
#include "DictValue.h"
#include "Hashable.h"

#define CEGFILESPEC_SUCCESS 			1

#define CEGFILESPEC_ALREADY_EXISTS		-2
#define CEGFILESPEC_FNF_ERR			-3
#define CEGFILESPEC_LOCKED_ERR			-4
#define CEGFILESPEC_DISK_FULL			-5
#define CEGFILESPEC_PATH_NOT_FOUND		-6

#define CEGFILESPEC_NOT_IMPLEMENTED		-55

#define CEGFILESPEC_CREATE_ERR			-20
#define CEGFILESPEC_DELETE_ERR			-21



/*
MacOS:

	If a CEgFileSpec is a

	    file: 		the contained FSSpec is the file spec
	    folder:     parID 	- dirID of parent dir
	    			name 	- dir name

Win32:

	If a CEgFileSpec is a

		file:		pathname
		folder:		pathname
*/


class CEgFileSpec : public DictValue, public Hashable {

protected:
	UtilStr			mSpecData;
	long			mFileType;
	UtilStr			mFileNameNE;
	UtilStr			mFileName;

	void			AssignFileName();

public:
	CEgFileSpec();
	CEgFileSpec( const char* inPathName, long inType = MCC4_TO_INT("TEXT")  );
	CEgFileSpec( const CEgFileSpec& inSpec );

	//	Returns 1 is the file is found, 2 if the folder is found, 0 if not found
	int			Exists() const;

	// 	Appends "1", "2", "3", ... until the file name is unique/not taken
	void			MakeUnique();

	void			Assign( const CEgFileSpec& inSpec );
	void			AssignPathName( const char* inPathName, const CEgFileSpec* inFromFolder = NULL );

	// Assigns this spec to tbe the parent of the given spec
	void			AssignParent( CEgFileSpec& inSpec );

	// Assigns this spec to the root dir of the startup volume
	void			AssignDefaultVol();

	void			Assign( const void* inOSSpecPtr, long inType = MCC4_TO_INT("TEXT") );

	CEgErr			Duplicate( const CEgFileSpec& inDestSpec ) const;
	void			SaveAs( const CEgFileSpec& inDestSpec ) const;
	void			ChangeExt( const char* inExt );

	long			GetType() const;
	void			SetType( long inType );

	const void*		OSSpec() const;

	//	Post:	Returns the filename of this spec (GetFileNameNE() returns it with no extension and GetFileNameE() with)
	//	Usgae:	"dir1\Blah.BL" ==>	Returns "Blah.BL" (or "Blah")
	const UtilStr*		GetFileName( bool inExtension = true ) const												{ return ( inExtension ) ? &mFileName : &mFileNameNE;		}
	void			GetFileName( UtilStr& outName, bool inExtension = true ) const								{ outName.Assign( GetFileName( inExtension ) );				}

	// Returns the capitalized extension (of any) for the spec (ex, "TXT", "DOC")
	void			GetExtension( UtilStr& outExt ) const;

	// Returns the textual volume and folder pathname of this file spec
	void			GetPathname( UtilStr& outPathname ) const;

	//	Post:	Sets this spec's filename, keeping the path information the same.
	void			Rename( const UtilStr& inNewName );

	//	Post:	<inType> will be appended onto the end of <ioStr>.
	//	Ex:		TypeToExt( "blah", '.AB' ) returns "blah.AB" in ioStr.
	static void		TypeToExt( UtilStr& ioStr, long inType );

	// Handy way to check extensions...
	bool			IsTextFile();

	// Case insensitive extension compare.  Ex, if the filename was "andy.bmp", then: this.CompareExtn( ".BMP" ) == true
	bool			CompareExtn( const char* inExtension );

	//bool			AssignFolder( const char* inFolderName, const CEgFileSpec* inFromFolder = NULL );

	// Returns: One of the above CEGFILESPEC_XXXX codes or CEGFILESPEC_SUCCESS
	int			CreateFolder( bool inReplace ) const;
	int			Delete() const;

	// Post:	Returns a psudorandom long for this string
	long			Hash( long inParam ) const;

	// Must be defined as a Hashable
	bool			Equals( const Hashable* inComp, long inParam ) const;
};

#endif // _C_EG_FILE_SPEC_H__
