
#ifndef __ABSTRACT_STR_LIST_H__
#define __ABSTRACT_STR_LIST_H__

#include "XPtrList.h"
#include "AbstractStrAccess.h"


class AbstractStrList : public AbstractStrAccess {

public:
	AbstractStrList( XStrListOptsT inOption, CompFunctionT inCompFcn );
	virtual	~AbstractStrList();


	// 	See AbstractStrAccess.h
	virtual long			Count() const											{ return mItems.Count();						}

	//	Describes the order/sort of the strings in this array
	virtual void			SetListOrdering( XStrListOptsT inNewOrder );

	virtual void			RemoveAll();
	virtual void			Remove( long inIndex );

protected:
	XPtrList			mItems;

	virtual void			DeleteItem( void* inPtr ) = 0;
};

#endif // __ABSTRACT_STR_LIST_H__
