/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2003 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __DISPLAYER_CLIST_STATUS_H__
#define __DISPLAYER_CLIST_STATUS_H__

#include "singit/song.h"
#include "singit/config_gen.h"
#include "singit/singleton.h"

#ifdef __cplusplus
extern "C" {
#endif // * __cplusplus *

#define TYPE_CLIST_STATUS            (clist_status_get_type ())
#define CLIST_STATUS(obj)            (GTK_CHECK_CAST ((obj), TYPE_CLIST_STATUS, ClistStatus))
#define CLIST_STATUS_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), TYPE_CLIST_STATUS, ClistStatus))
#define IS_CLIST_STATUS(obj)         (GTK_CHECK_TYPE ((obj), TYPE_CLIST_STATUS))
#define IS_CLIST_STATUS_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TYPE_CLIST_STATUS))

typedef struct _ClistStatus       ClistStatus;
typedef struct _ClistStatusClass  ClistStatusClass;

struct _ClistStatus {

	SingitSingleton       singleton;

	SingitConfigGen      *config;

	SingitSong           *song;
	GList                *next_lyric_line;

	gint                  lastRow;
	gint                  line;
	gint                  pos;
	gint                  jump_to_song;

	guint                 timestamp_context_id;
	guint                 song_context_id;
	gint                  messageCounter;

	gint                  win_size_y;
};

struct _ClistStatusClass {

	SingitSingletonClass  parent_class;
};

GtkType            clist_status_get_type(void);

SingitSingleton*   clist_status_ref(void);
void               clist_status_unref(SingitSingleton** single);

SingitSingleton*   clist_status_noref(void);

#define STATUS \
	CLIST_STATUS(clist_status_noref())

#ifdef __cplusplus
}
#endif // * __cplusplus *

#endif // __DISPLAYER_CLIST_STATUS_H__
