/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
#ifndef	__INFINITY_CONFIG__
#define __INFINITY_CONFIG__


#include <glib.h>


/*
 * This structure is intended to be used for every module
 * that want to get your own copy of the screen parameters,
 * it is not used by the config module itself.
 * Is responsibility of the modules that create his own
 * copy of the screen parameters to keep consistent that
 * parameters with each other copy, it is not responsibility
 * of the config module.
 */
typedef struct _t_screen_parameters {
    int x, y;
    int width;
    int height;
    int scale;
    int bpp;    /**< bytes per pixels. */
} t_screen_parameters;


/*
 * Read user preferences from ~/.xmms/config file
 */
void config_plugin_load_prefs (void);

void config_plugin_save_prefs (void);

void config_set_default_values (void);

/*
 * \return TRUE if config_plugin_load_prefs() or
 * config_set_default_values() has been called.
 */
gboolean config_is_initialized (void);

/*
 * Open a window to let the user choose and 
 * save your options.
 */
void config_plugin_config_window (void);

void config_set_x (int value);
void config_set_y (int value);
void config_set_xres (int value);
void config_set_yres (int value);
void config_set_sres (int value);
void config_set_teff (int value);
void config_set_tcol (int value);

int config_get_x (void);
int config_get_y (void);
int config_get_xres (void);
int config_get_yres (void);
int config_get_sres (void);
int config_get_teff (void);
int config_get_tcol (void);


#endif /* __INFINITY_CONFIG__ */
