/*
 * xlog - GTK+ logging program for amateur radio operators
 * Copyright (C) 2001 - 2005 Joop Stakenborg <pg4i@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* gui_defaultsdialog.c - creation and destruction of the defaults dialog
 *
 * a dialog is created where you can fill in default values to use for 
 * "click all" for the mhz, mode, rxrst, txrst, power, freefield1, freefield2
 * and remarks log entries.
 */

#include <gtk/gtk.h>
#include <string.h>

#include "support.h"
#include "types.h"

extern GtkWidget *mainwindow;
extern preferencestype preferences;

void
on_menu_defaults_activate (GtkMenuItem * menuitem, gpointer user_data)
{
	GtkWidget *defaultsmhzentry, *defaultsmodeentry, *defaultstxrstentry,
		*defaultsrxrstentry, *defaultspowerentry, *defaultsdialog,
		*defaultsfreefield1entry, *defaultsfreefield2entry, *defaultsremarksentry,
		*defaultsfreefield1label, *defaultsfreefield2label,
		*mainvbox, *defaultslabel, *frame, *framevbox, *hbox1, *mhzlabel,
		*hbox2, *modelabel, *hbox3, *txrstlabel, *hbox4, *rxrstlabel,
		*hbox5, *powerlabel, *hbox6, *hbox7, *hbox8, *remarkslabel;
	gchar *temp;
	gint response;

	defaultsdialog = gtk_dialog_new_with_buttons (_("xlog - defaults"),
		GTK_WINDOW(mainwindow), GTK_DIALOG_DESTROY_WITH_PARENT,
		GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, 
		GTK_STOCK_OK, GTK_RESPONSE_OK, NULL);

	mainvbox = gtk_vbox_new (FALSE, 0);
	gtk_container_add
		(GTK_CONTAINER (GTK_DIALOG (defaultsdialog)->vbox), mainvbox);

	defaultslabel = gtk_label_new (_("Values to use for 'Click all' or Ctl+k"));
	gtk_box_pack_start (GTK_BOX (mainvbox), defaultslabel, FALSE, FALSE, 10);
	frame = gtk_frame_new (NULL);
	gtk_box_pack_start (GTK_BOX (mainvbox), frame, FALSE, FALSE, 0);
	framevbox = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (frame), framevbox);
	hbox1 = gtk_hbox_new (TRUE, 0);
	gtk_box_pack_start (GTK_BOX (framevbox), hbox1, FALSE, FALSE, 0);

	mhzlabel = gtk_label_new ("MHz");
	gtk_box_pack_start (GTK_BOX (hbox1), mhzlabel, FALSE, FALSE, 0);
	gtk_label_set_justify (GTK_LABEL (mhzlabel), GTK_JUSTIFY_CENTER);
	defaultsmhzentry = gtk_entry_new ();
	gtk_box_pack_start (GTK_BOX (hbox1), defaultsmhzentry, FALSE, FALSE, 0);
	gtk_widget_set_size_request (defaultsmhzentry, 150, -1);
	gtk_entry_set_max_length (GTK_ENTRY (defaultsmhzentry), 15);
	hbox2 = gtk_hbox_new (TRUE, 0);
	gtk_box_pack_start (GTK_BOX (framevbox), hbox2, FALSE, FALSE, 0);
	modelabel = gtk_label_new (_("Mode"));
	gtk_box_pack_start (GTK_BOX (hbox2), modelabel, FALSE, FALSE, 0);
	defaultsmodeentry = gtk_entry_new ();
	gtk_box_pack_start (GTK_BOX (hbox2), defaultsmodeentry, FALSE, FALSE, 0);
	gtk_widget_set_size_request (defaultsmodeentry, 150, -1);
	gtk_entry_set_max_length (GTK_ENTRY (defaultsmodeentry), 8);
	hbox3 = gtk_hbox_new (TRUE, 0);
	gtk_box_pack_start (GTK_BOX (framevbox), hbox3, FALSE, FALSE, 0);
	txrstlabel = gtk_label_new ("TX(RST)");
	gtk_box_pack_start (GTK_BOX (hbox3), txrstlabel, FALSE, FALSE, 0);
	defaultstxrstentry = gtk_entry_new ();
	gtk_box_pack_start (GTK_BOX (hbox3), defaultstxrstentry, FALSE, FALSE, 0);
	gtk_widget_set_size_request (defaultstxrstentry, 150, -1);
	gtk_entry_set_max_length (GTK_ENTRY (defaultstxrstentry), 15);
	hbox4 = gtk_hbox_new (TRUE, 0);
	gtk_box_pack_start (GTK_BOX (framevbox), hbox4, FALSE, FALSE, 0);
	rxrstlabel = gtk_label_new ("RX(RST)");
	gtk_box_pack_start (GTK_BOX (hbox4), rxrstlabel, FALSE, FALSE, 0);
	defaultsrxrstentry = gtk_entry_new ();
	gtk_box_pack_start (GTK_BOX (hbox4), defaultsrxrstentry, FALSE, FALSE, 0);
	gtk_widget_set_size_request (defaultsrxrstentry, 150, -1);
	gtk_entry_set_max_length (GTK_ENTRY (defaultsrxrstentry), 15);
	hbox5 = gtk_hbox_new (TRUE, 0);
	gtk_box_pack_start (GTK_BOX (framevbox), hbox5, FALSE, FALSE, 0);
	powerlabel = gtk_label_new (_("Power"));
	gtk_box_pack_start (GTK_BOX (hbox5), powerlabel, FALSE, FALSE, 0);
	defaultspowerentry = gtk_entry_new ();
	gtk_box_pack_start (GTK_BOX (hbox5), defaultspowerentry, FALSE, FALSE, 0);
	gtk_widget_set_size_request (defaultspowerentry, 150, -1);
	gtk_entry_set_max_length (GTK_ENTRY (defaultspowerentry), 8);
	hbox6 = gtk_hbox_new (TRUE, 0);
	gtk_box_pack_start (GTK_BOX (framevbox), hbox6, FALSE, FALSE, 0);
	defaultsfreefield1label = gtk_label_new (_("Freefield1"));
	gtk_box_pack_start (GTK_BOX (hbox6), defaultsfreefield1label, FALSE, FALSE, 0);
	defaultsfreefield1entry = gtk_entry_new ();
	gtk_box_pack_start (GTK_BOX (hbox6), defaultsfreefield1entry, FALSE, FALSE, 0);
	gtk_widget_set_size_request (defaultsfreefield1entry, 150, -1);
	gtk_entry_set_max_length (GTK_ENTRY (defaultsfreefield1entry), 30);
	hbox7 = gtk_hbox_new (TRUE, 0);
	gtk_box_pack_start (GTK_BOX (framevbox), hbox7, FALSE, FALSE, 0);
	defaultsfreefield2label = gtk_label_new (_("Freefield2"));
	gtk_box_pack_start (GTK_BOX (hbox7), defaultsfreefield2label, FALSE, FALSE, 0);
	defaultsfreefield2entry = gtk_entry_new ();
	gtk_box_pack_start (GTK_BOX (hbox7), defaultsfreefield2entry, FALSE, FALSE, 0);
	gtk_widget_set_size_request (defaultsfreefield2entry, 150, -1);
	gtk_entry_set_max_length (GTK_ENTRY (defaultsfreefield2entry), 30);
	hbox8 = gtk_hbox_new (TRUE, 0);
	gtk_box_pack_start (GTK_BOX (framevbox), hbox8, FALSE, FALSE, 0);
	remarkslabel = gtk_label_new (_("Remarks"));
	gtk_box_pack_start (GTK_BOX (hbox8), remarkslabel, FALSE, FALSE, 0);
	defaultsremarksentry = gtk_entry_new ();
	gtk_box_pack_start (GTK_BOX (hbox8), defaultsremarksentry, FALSE, FALSE, 0);
	gtk_widget_set_size_request (defaultsremarksentry, 150, -1);
	gtk_entry_set_max_length (GTK_ENTRY (defaultsremarksentry), 80);

	gtk_label_set_text (GTK_LABEL(defaultsfreefield1label), 
		preferences.freefield1);
	gtk_label_set_text (GTK_LABEL(defaultsfreefield2label), 
		preferences.freefield2);

	if (g_ascii_strcasecmp (preferences.defaultmhz, "?"))
		gtk_entry_set_text (GTK_ENTRY (defaultsmhzentry), preferences.defaultmhz);
	if (g_ascii_strcasecmp (preferences.defaultmode, "?"))
		gtk_entry_set_text (GTK_ENTRY (defaultsmodeentry),
			preferences.defaultmode);
	if (g_ascii_strcasecmp (preferences.defaulttxrst, "?"))
		gtk_entry_set_text (GTK_ENTRY (defaultstxrstentry),
			preferences.defaulttxrst);
	if (g_ascii_strcasecmp (preferences.defaultrxrst, "?"))
		gtk_entry_set_text (GTK_ENTRY (defaultsrxrstentry),
			preferences.defaultrxrst);
	if (g_ascii_strcasecmp (preferences.defaultpower, "?"))
		gtk_entry_set_text (GTK_ENTRY (defaultspowerentry),
			preferences.defaultpower);
	if (g_ascii_strcasecmp (preferences.defaultfreefield1, "?"))
		gtk_entry_set_text (GTK_ENTRY (defaultsfreefield1entry),
			preferences.defaultfreefield1);
	if (g_ascii_strcasecmp (preferences.defaultfreefield2, "?"))
		gtk_entry_set_text (GTK_ENTRY (defaultsfreefield2entry),
			preferences.defaultfreefield2);
	if (g_ascii_strcasecmp (preferences.defaultremarks, "?"))
		gtk_entry_set_text (GTK_ENTRY (defaultsremarksentry),
			preferences.defaultremarks);

	gtk_widget_show_all (defaultsdialog);
	response = gtk_dialog_run (GTK_DIALOG(defaultsdialog));
	if (response == GTK_RESPONSE_OK)
	{
		temp = gtk_editable_get_chars (GTK_EDITABLE (defaultsmhzentry), 0, -1);
		if (strlen (temp) == 0)
			preferences.defaultmhz = g_strdup ("?");
		else if (g_ascii_strcasecmp (preferences.defaultmhz, temp))
			preferences.defaultmhz = g_strdup (temp);
		temp = gtk_editable_get_chars (GTK_EDITABLE (defaultsmodeentry), 0, -1);
		if (strlen (temp) == 0)
			preferences.defaultmode = g_strdup ("?");
		else if (g_ascii_strcasecmp (preferences.defaultmode, temp))
			preferences.defaultmode = g_strdup (temp);
		temp = gtk_editable_get_chars (GTK_EDITABLE (defaultstxrstentry), 0, -1);
		if (strlen (temp) == 0)
			preferences.defaulttxrst = g_strdup ("?");
		else if (g_ascii_strcasecmp (preferences.defaulttxrst, temp))
			preferences.defaulttxrst = g_strdup (temp);
		temp = gtk_editable_get_chars (GTK_EDITABLE (defaultsrxrstentry), 0, -1);
		if (strlen (temp) == 0)
			preferences.defaultrxrst = g_strdup ("?");
		else if (g_ascii_strcasecmp (preferences.defaultrxrst, temp))
			preferences.defaultrxrst = g_strdup (temp);
		temp = gtk_editable_get_chars (GTK_EDITABLE (defaultspowerentry), 0, -1);
		if (strlen (temp) == 0)
			preferences.defaultpower = g_strdup ("?");
		else if (g_ascii_strcasecmp (preferences.defaultpower, temp))
			preferences.defaultpower = g_strdup (temp);
		temp = gtk_editable_get_chars (GTK_EDITABLE (defaultsfreefield1entry), 0, -1);
		if (strlen (temp) == 0)
			preferences.defaultfreefield1 = g_strdup ("?");
		else if (g_ascii_strcasecmp (preferences.defaultfreefield1, temp))
			preferences.defaultfreefield1 = g_strdup (temp);
		temp = gtk_editable_get_chars (GTK_EDITABLE (defaultsfreefield2entry), 0, -1);
		if (strlen (temp) == 0)
			preferences.defaultfreefield2 = g_strdup ("?");
		else if (g_ascii_strcasecmp (preferences.defaultfreefield2, temp))
			preferences.defaultfreefield2 = g_strdup (temp);
		temp = gtk_editable_get_chars (GTK_EDITABLE (defaultsremarksentry), 0, -1);
		if (strlen (temp) == 0)
			preferences.defaultremarks = g_strdup ("?");
		else if (g_ascii_strcasecmp (preferences.defaultremarks, temp))
			preferences.defaultremarks = g_strdup (temp);
		g_free (temp);
	}
	gtk_widget_destroy (defaultsdialog);
}
