#!/bin/sh
#
# convert all povray sprite ppms to epms
#
# Program XBLAST V2.6 or higher
# (C) by Oliver Vogel (e-mail: m.vogel@ndh.net)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published
# by the Free Software Foundation; either version 2; or (at your option)
# any later version
#
# This program is distributed in the hope that it will be entertaining,
# but WITHOUT ANY WARRANTY; without even the implied warranty of 
# MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
# Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.
# 675 Mass Ave, Cambridge, MA 02139, USA.
#

# Destination directory
DST_DIR="${HOME}/image-test/sprite"

if test ! -d $DST_DIR; then
    echo "$0: destination directory $DST_DIR does not exist"
fi

#
# check commandline
#
USE_DIR=0
USE_ANI=0
#
SPEC=0
BIGO=0
NORM=0
SKEL=0
NDIR=""
for i in $*; do
    case $i in
    # animation sub sets
    -sp* ) SPEC=1; USE_ANI=1;;
    -b*  ) BIGO=1; USE_ANI=1;;
    -n*  ) NORM=1; USE_ANI=1;;
    -sk* ) SKEL=1; USE_ANI=1;;
    # shapes
    -N*  ) USE_DIR=1; NDIR=$NDIR" "./normal ;;
    -G*  ) USE_DIR=1; NDIR=$NDIR" "./girl   ;;
    -F*  ) USE_DIR=1; NDIR=$NDIR" "./fat    ;;
    -T*  ) USE_DIR=1; NDIR=$NDIR" "./tall   ;;
    -S*  ) USE_DIR=1; NDIR=$NDIR" "./skull  ;;
    esac
done

#
# set animations subsets
#
if test $USE_ANI -eq 0; then
    SPEC=1
    BIGO=1
    NORM=1
    SKEL=1
fi

#
# set source dirs
#
if test $USE_DIR -eq 1; then
    # use only selected ones
    DIRS=$NDIR
else
    # use alls source dirs
    DIRS="./normal ./girl ./fat ./tall ./skull"
fi


#
# loop over all source dirs
#
for SRC in $DIRS; do

    echo $SRC
    #
    # set output name
    #
    case $SRC in
    *normal ) DST=${DST_DIR}/normal_ ;;
    *girl   ) DST=${DST_DIR}/girl_   ;;
    *fat    ) DST=${DST_DIR}/fat_    ;;
    *tall   ) DST=${DST_DIR}/tall_   ;;
    *skull  ) DST=${DST_DIR}/skull_  ;;
    esac

    #
    # big winner sprites
    #
    
    if test $BIGO -eq 1; then
	I=1
	IN=${SRC}/big_
    
	EPMCUT="pnmcut 0 30 128 152"
  
	EPM=${DST}B.epm
	PBM=${DST}B.pbm
  
	J=`expr $I + 1`      
	K=`expr $I + 2`      
	L=`expr $I + 3`      
	II=`printf \%1d $I`
	JJ=`printf \%1d $J`
	KK=`printf \%1d $K`
	LL=`printf \%1d $L`
  
	if test ! -s ${EPM} || test ${IN}${JJ}.ppm.gz -nt ${EPM}; then
    
	    echo "Converting $II $EPM"
    
	    if  gzip -d -c ${IN}${II}.ppm.gz 2>/dev/null | eval $EPMCUT >1.ppm \
	     && gzip -d -c ${IN}${JJ}.ppm.gz 2>/dev/null | eval $EPMCUT >2.ppm \
	     && gzip -d -c ${IN}${KK}.ppm.gz 2>/dev/null | eval $EPMCUT >3.ppm \
	     && gzip -d -c ${IN}${LL}.ppm.gz 2>/dev/null | eval $EPMCUT >4.ppm; \
	    then 
      
		./etc/topgm.sh 1.ppm 2.ppm 3.ppm 4.ppm
		pgmtoepm helmet.pgm face.pgm body.pgm handsfeet.pgm \
		    armslegs.pgm backpack.pgm highlight.pgm >${EPM}
		epmcompress ${EPM}
		rm -f ${EPM}~
		mv mask.pbm ${PBM}
      
		rm [1234].ppm *.pgm
      
	    else
      
		echo "... but skipped"
      
	    fi

	else
    
	    echo "Skipping $II $EPM"
    
	fi
  
	I=`expr $I + 4`
    
    fi
  

    #
    # special sprites
    #
    if test $SPEC -eq 1; then 
	I=1
	IN=${SRC}/special_
  
	for A in L L1 L2 W W2 W3 DD DL DU DR ; do
    
	    case $A in
		L  ) EPMCUT="pnmcut 0 24 64 66";;
		L1 ) EPMCUT="pnmcut 0 24 64 66";;
		L2 ) EPMCUT="pnmcut 0 24 64 66";;
		W  ) EPMCUT="pnmcut 0 12 64 78";;
		W2 ) EPMCUT="pnmcut 0 12 64 78";;
		W3 ) EPMCUT="pnmcut 0 18 64 72";;
		DD ) EPMCUT="pnmcut 0 24 64 72";;
		DL ) EPMCUT="pnmcut 0 36 64 60";;
		DU ) EPMCUT="pnmcut 0 42 64 48";;
		DR ) EPMCUT="pnmcut 0 36 64 60";;
	    esac
		
	    EPM=${DST}${A}.epm
	    PBM=${DST}${A}.pbm
		
	    J=`expr $I + 1`      
	    K=`expr $I + 2`      
	    L=`expr $I + 3`      
	    II=`printf \%02d $I`
	    JJ=`printf \%02d $J`
	    KK=`printf \%02d $K`
	    LL=`printf \%02d $L`
		
	    if test ! -s ${EPM} || test ${IN}${JJ}.ppm.gz -nt ${EPM}; then
		
		echo "Converting $II $EPM"
		    
		if  gzip -d -c ${IN}${II}.ppm.gz 2>/dev/null | eval $EPMCUT >1.ppm \
		    && gzip -d -c ${IN}${JJ}.ppm.gz 2>/dev/null | eval $EPMCUT >2.ppm \
		    && gzip -d -c ${IN}${KK}.ppm.gz 2>/dev/null | eval $EPMCUT >3.ppm \
		    && gzip -d -c ${IN}${LL}.ppm.gz 2>/dev/null | eval $EPMCUT >4.ppm; \
		then 
		    
		    ./etc/topgm.sh 1.ppm 2.ppm 3.ppm 4.ppm
		    pgmtoepm helmet.pgm face.pgm body.pgm handsfeet.pgm armslegs.pgm \
			backpack.pgm highlight.pgm >${EPM}
		    epmcompress ${EPM}
		    rm -f ${EPM}~
		    mv mask.pbm ${PBM}
			
		    rm [1234].ppm *.pgm
			
		else
		    
		    echo "... but skipped"
			
		fi
		    
	    else
      
		echo "Skipping $II $EPM"	
      
	    fi
    
	    I=`expr $I + 4`
    
	done 
      
    fi

    # 
    # "normal" sprites
    #
    if test $NORM -eq 1; then
    
	I=1
	IN=${SRC}/player_
    
	for D in D L U R; do
	    
	    case $D in
	    D ) EPMCUT="pnmcut 0 18 64 78";;
	    L ) EPMCUT="pnmcut 0 24 64 72";;
	    U ) EPMCUT="pnmcut 0 24 64 66";;
	    R ) EPMCUT="pnmcut 0 24 64 66";;
	    esac
	    
	    for A in S 0 1 2 3 ; do
	    
		EPM=${DST}${D}_${A}.epm
		PBM=${DST}${D}_${A}.pbm
		J=`expr $I + 1`      
		K=`expr $I + 2`      
		L=`expr $I + 3`      
		II=`printf \%02d $I`
		JJ=`printf \%02d $J`
		KK=`printf \%02d $K`
		LL=`printf \%02d $L`
		
		if test ! -s ${EPM} || test ${IN}${JJ}.ppm.gz -nt ${EPM}; then
		
		    echo "Converting $II $EPM"
		    
		    if  gzip -d -c ${IN}${II}.ppm.gz 2>/dev/null | eval $EPMCUT >1.ppm \
			&& gzip -d -c ${IN}${JJ}.ppm.gz 2>/dev/null | eval $EPMCUT >2.ppm \
			&& gzip -d -c ${IN}${KK}.ppm.gz 2>/dev/null | eval $EPMCUT >3.ppm \
			&& gzip -d -c ${IN}${LL}.ppm.gz 2>/dev/null | eval $EPMCUT >4.ppm; then 
			
			./etc/topgm.sh 1.ppm 2.ppm 3.ppm 4.ppm
			pgmtoepm helmet.pgm face.pgm body.pgm handsfeet.pgm armslegs.pgm \
			    backpack.pgm highlight.pgm >${EPM}
			epmcompress ${EPM}
			rm -f ${EPM}~
			mv mask.pbm ${PBM}
			
			rm [1234].ppm *.pgm
			    
		    else
		    
			echo "... but skipped"
			
		    fi
		    
		else
		
		    echo "Skipping $II $EPM"
		    
		fi
		
		I=`expr $I + 4`
		
	    done 
	    
	done
	
    fi

done

#
# skeleton sprite
#
if test $SKEL -eq 1; then 
  I=1
  IN=skeleton/skeleton_
  for A in D L U R; do
    
    case $A in
      D ) PPMCUT="pnmcut 0 30 64 60";;
      L ) PPMCUT="pnmcut 0 30 64 66";;
      U ) PPMCUT="pnmcut 0 30 64 54";;
      R ) PPMCUT="pnmcut 0 30 64 66";;
    esac
    
    PPM=${DST_DIR}/skel_${A}.ppm
    PBM=${DST_DIR}/skel_${A}.pbm
    
    J=`expr $I + 1`
    
    if test ! -s ${PPM} || test ${IN}${I}.ppm.gz -nt ${PPM}; then
      
      echo "Converting $I $PPM"
      
      if gzip -d -c ${IN}${I}.ppm.gz >B.ppm \
       && gzip -d -c ${IN}${J}.ppm.gz >W.ppm ; then
	
	./etc/tosprite.sh B.ppm W.ppm
	rm W.ppm B.ppm
	
	cat sprite.ppm | eval $PPMCUT  >${PPM}
	cat mask.pbm   | eval $PPMCUT  >${PBM}
	
	rm sprite.ppm mask.pbm
	
      else
	
	echo "... but skipped"
	
      fi
      
    else
      
      echo "Skipping $II $PPM"
      
    fi
    
    I=`expr $I + 2`
    
  done

fi

#
# end file dosprites
#
