#include "xev.h"
#include "enemy.h"

PRIVATE Pixmap pixmap[5],pixmap_mask[5];
PRIVATE GC gc[5];
PRIVATE int rogram_anim[16] = {0,1,1,1,2,2,2,3,3,2,2,1,1,1,1,0};
PRIVATE int shot_p[5][3] = {
      {0,1,3},
      {2,5,7},
      {3,5,12},
      {3,8,20},
      {10,15,30}
};

PRIVATE int br_no[4];

PRIVATE char *fn[] = {
      "rogram.img",
      "rogram1.img",
      "rogram2.img",
      "rogram3.img",
      "bozarog.img"
};

void RogramSetChar()
{
      int c_no;
      char img[CSIZE*CSIZE] , mask[128];
      XGCValues gcv;

      gcv.graphics_exposures = False;
      for(c_no = 0 ; c_no < 5 ; c_no++) {
            int x,y;
            
	    sprintf(tpath , "%s/%s",IMAGE_DIR,fn[c_no]);
            LoadChar(tpath,img , sizeof(img));
            pixmap[c_no] = XCreatePixmap(d,w,CSIZE,CSIZE,depth);
	    gc[c_no] = XCreateGC(d,w,GCGraphicsExposures,&gcv);
            bzero(mask , sizeof(mask));
            
	    DrawChar32(img , mask , gc[c_no],pixmap[c_no]);
	    pixmap_mask[c_no] 
	      = XCreateBitmapFromData(d,w,mask,CSIZE,CSIZE);
            XSetClipMask(d,gc[c_no],pixmap_mask[c_no]);
      }
      
}

void RogramFree()
{
      int i;
      
      for(i = 0 ; i > 5 ; i++) {
            XFreePixmap(d,pixmap[i]);
            XFreePixmap(d,pixmap_mask[i]);
	    XFreeGC(d,gc[i]);
      }
}

int Rogram(enemy_no)
     int enemy_no;
{
      int sx,sy;
      sx = enemy_chijou[enemy_no].x.sht[UNION];
      sy = enemy_chijou[enemy_no].y.sht[UNION];


      enemy_chijou[enemy_no].y.dummy += enemy_chijou[enemy_no].vy;
      if (!enemy_chijou[enemy_no].tmp1 && (rand() & 255) 
	  < shot_p[game_level][level]) {
            enemy_chijou[enemy_no].tmp1 = 16;
      }
      if(enemy_chijou[enemy_no].tmp1 == 7)
        EShut(enemy_no,enemy_chijou[enemy_no].x.dummy+16*65536
              ,enemy_chijou[enemy_no].y.dummy+16*65536);

      enemy_chijou[enemy_no].tmp1 -=
        (enemy_chijou[enemy_no].tmp1 > 0);

      SetSprite(sx,sy+2,pixmap[rogram_anim[enemy_chijou[enemy_no].tmp1]],
		gc[rogram_anim[enemy_chijou[enemy_no].tmp1]],
		CSIZE,CSIZE);

      if(sy > YSIZE) {
            enemy_chijou[enemy_no].enemy_no = 0;
      }
      if((jx.sht[UNION] - sx) > -20 &&
         (jx.sht[UNION] - sx) < 20 &&
         (jy.sht[UNION] - sy) > 192 &&
         (jy.sht[UNION] - sy) < 224)
        shojun_flag = 1;

      if(shot_chi.z == 1) {
	    if((shot_chi.x.sht[UNION] - sx) > -10 &&
	       (shot_chi.x.sht[UNION] - sx) < 32 &&
	       (shot_chi.y.sht[UNION] - sy) > -10 &&
	       (shot_chi.y.sht[UNION] - sy) < 42) {
		  BombCInit(enemy_no);
		  score += 300;
		  return 1;
	    }
      }else
        return 0;

}

void BozaRogInit(enemy_no , x, char_no)
     int enemy_no,x,char_no;
{
      int i,j;
      static int vx[4] = {0,0,48,-48};
      static int vy[4] = {24,-24,0,0};

      enemy_chijou[enemy_no].tmp1 = 0;
      enemy_chijou[enemy_no].tmp2 = 0;
      enemy_chijou[enemy_no].enemy_no  = char_no;
      enemy_chijou[enemy_no].x.dummy = x*CSIZE*32768;
      enemy_chijou[enemy_no].y.dummy = -64*65536;
      enemy_chijou[enemy_no].vx = 0;
      enemy_chijou[enemy_no].vy = STPF*65536;
      
      for(j = 0 ; j < 4 ; j++) {
	    for(i = 0 ; i < ENEMY_MAX ; i++) {
		  if(enemy_chijou[i].enemy_no != 0)
		    continue;
		  
		  br_no[j] = i;
		  enemy_chijou[i].tmp1 = 0;
		  enemy_chijou[i].tmp2 = 0;
		  enemy_chijou[i].enemy_no = ROGRAM;
		  enemy_chijou[i].x.dummy = (x*CSIZE+vx[j])*32768;
		  enemy_chijou[i].y.dummy = (vy[j]-64)*65536;
		  enemy_chijou[i].vx = 0;
		  enemy_chijou[i].vy = STPF*65536;
		  enemy_chijou[i].tmp3 = 1;
		  break;
	    }
      }

      if(map[scrl_ptr][x] == UMINO)
        enemy_chijou[enemy_no].tmp3 = 0;
      else
        enemy_chijou[enemy_no].tmp3 = 1;
      
}

int BozaRogram(enemy_no)
     int enemy_no;
{
      int sx,sy;
      
      sx = enemy_chijou[enemy_no].x.sht[UNION];
      sy = enemy_chijou[enemy_no].y.sht[UNION];
      enemy_chijou[enemy_no].y.dummy += enemy_chijou[enemy_no].vy;

      SetSprite(sx,sy+2,pixmap[4],
		gc[4],
		CSIZE,CSIZE);

      if(sy > YSIZE) {
            enemy_chijou[enemy_no].enemy_no = 0;
      }
      if((jx.sht[UNION] - sx) > -20 &&
         (jx.sht[UNION] - sx) < 20 &&
         (jy.sht[UNION] - sy) > 192 &&
         (jy.sht[UNION] - sy) < 224)
        shojun_flag = 1;

      if(shot_chi.z == 1) {
	    if((shot_chi.x.sht[UNION] - sx) > -10 &&
	       (shot_chi.x.sht[UNION] - sx) < 32 &&
	       (shot_chi.y.sht[UNION] - sy) > -10 &&
	       (shot_chi.y.sht[UNION] - sy) < 42) {
		  int i;
		  
		  for(i = 0 ; i < 4 ; i++) {
			if(enemy_chijou[br_no[i]].enemy_no != ROGRAM)
			  continue;
			
			BombCInit(br_no[i]);
		  }
		  
		  BombCInit(enemy_no);
		  score += 1000;
		  return 1;
	    }
      }else
        return 0;
}

