/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef	JT44Message_H
#define	JT44Message_H

#include "JT44MessageBase.h"

#include <wx/wx.h>

#include "common/Average.h"

class CJT44Message : public CJT44MessageBase {

    public:
	CJT44Message();
	virtual ~CJT44Message();

	virtual void setId(const wxString& id);
	virtual void setDt(double Dt);
	virtual void setDF(int DF);
	virtual void setInclude();
	virtual void setExclude();

	virtual void setData(int letter, int pos, double data);
	virtual void setSync(int pos, double data);
	virtual void setNoise(int pos, double data);

	virtual wxString getId() const;
	virtual double   getDt() const;
	virtual int      getDF() const;
	virtual bool     getInclude() const;

    private:
	wxString m_id;
	double   m_Dt;
	int      m_DF;
	bool     m_include;
};

WX_DECLARE_LIST(CJT44Message, CJT44MessageList);

#endif
