/* parentactionop.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2004 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: parentactionop.cc,v 1.3 2004/12/12 21:49:30 ralf Exp $ */

#include "parentactionop.h"
#include "listermode.h"
#include "normalmode.h"
#include "worker.h"
#include "wconfig.h"

const char *ParentActionOp::name = "ParentActionOp";

ParentActionOp::ParentActionOp() : FunctionProto()
{
}

ParentActionOp::~ParentActionOp()
{
}

ParentActionOp*
ParentActionOp::duplicate() const
{
  ParentActionOp *ta=new ParentActionOp();
  return ta;
}

bool
ParentActionOp::isName( const char *str )
{
  if ( strcmp( str, name ) == 0 ) return true; else return false;
}

const char *
ParentActionOp::getName()
{
  return name;
}

int
ParentActionOp::run( ActionMessage *msg )
{
  WCFiletype *ft;
  FunctionProto::run( msg );

  if ( msg->filetype != NULL ) {
    ft = msg->filetype->getParentType();
    if ( ft != NULL ) {
      ActionMessage amsg2( msg->getWorker() );
      List *l1;
 
      amsg2.flags = msg->flags;
      amsg2.mode = msg->mode;
      amsg2.startLister = msg->startLister;
      // FE is already a copy of the real FE so we don't need to make another copy
      //amsg2.fe = msg->fe;
      
      // but currently I do it anyway
      amsg2.setFE( msg->getFE() );
      
      amsg2.filetype = ft;
      amsg2.getActionList = msg->getActionList;

      if ( msg->getActionList != NULL ) {
	l1 = msg->getActionList( ft, msg->getActionListID, &( amsg2.flags ) );
      } else {
	l1 = NULL;
      }

      msg->getWorker()->interpret( l1, &amsg2 );
    }
  }

  return 0;
}

const char *
ParentActionOp::getDescription()
{
  return catalog.getLocaleCom( 46 );
}
