/*
 * WallFire -- a comprehensive firewall administration tool.
 * 
 * Copyright (C) 2001 Herv Eychenne <rv@wallfire.org>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef _LIST1_H
#define _LIST1_H

#include <iterator>
#include <iostream>
#include <list>


/* list1_print... choose a better name!
   and another mecanism (list subclass?) RV@@4 */
template<class T>
void
list1_print(const list<T>& lst, int always_parenthesis, ostream& os) {
  typename list<T>::const_iterator first = lst.begin(), last = lst.end();
  bool parenthesis = false;

  /* Display '()' only if there are several elements, or if we always print
     parenthesis. */
  if (lst.size() > 1 || always_parenthesis) {
    os << '(';
    parenthesis = true;
  }

  while (first != last) {
    //    os << *first;
    (*first).print(os);
    ++first;
    if (first != last)
      os << ", ";
  }

  if (parenthesis) /* if we printed a '(', print a ')' */
    os << ')';
}

template<class T>
void
list1_ptrprint(const list<T>& lst, int always_parenthesis, ostream& os) {
  typename list<T>::const_iterator first = lst.begin(), last = lst.end();
  bool parenthesis = false;

  /* Display '()' only if there are several elements, or if we always print
     parenthesis. */
  if (lst.size() > 1 || always_parenthesis) {
    os << '(';
    parenthesis = true;
  }

  while (first != last) {
    //    os << *first;
    (**first).print(os);
    ++first;
    if (first != last)
      os << ", ";
  }

  if (parenthesis) /* if we printed a '(', print a ')' */
    os << ')';
}

template<class T>
void
list1_deepcopy(list<T>& dstlist, const list<T>& srclist) {
  dstlist.clear();
  back_insert_iterator<list<T> > i(dstlist);
  typename list<T>::const_iterator first = srclist.begin(),
    last = srclist.end();
  for (; first != last; ++first)
    *i++ = (*first)->VClone();
}

template<class T>
void
list1_firstncopy(list<T>& dstlist, const list<T>& srclist, int count) {
  typename list<T>::const_iterator first = srclist.begin(),
    last = srclist.end();
  for (; first != last && count > 0; ++first, --count)
    dstlist.insert(dstlist.begin(), *first);
}


#if 0 /* remove RV@@5 */
template<class T, class _Function>
void
list1_for_each(list<T> lst, ostream& os, _Function f) {
  typename list<T>::const_iterator first = lst.begin(), last = lst.end();
  for (; first != last; ++first)
    (*first).f(os);
}
#endif

#endif
