#!/usr/local/bin/perl
# backup.pl
# Called by cron to backup a database

$no_acl_check++;
require './mysql-lib.pl';

if ($ARGV[0] eq "--all") {
	$all = 1;
	@dbs = &list_databases();
	}
else {
	$ARGV[0] || die "Missing database parameter";
	@dbs = ( $ARGV[0] );
	}

$ex = 0;
foreach $db (@dbs) {
	if ($all) {
		$file = &date_subs("$config{'backup_'}/$db.sql");
		}
	else {
		$file = &date_subs($config{'backup_'.$db});
		}
	if (!$file) {
		print STDERR "No backup file set for database $db\n";
		exit(1);
		}
	$drop = $config{'backup_drop_'.$db} ? "--add-drop-table" : "";
	$where = $config{'backup_where_'.$db} ?
		"\"--where=".$config{'backup_where_'.$db}."\"" : "";
	if (&supports_quoting()) {
		$quoting = " --quote-names";
		}
	@tables = split(/\s+/, $config{'backup_tables_'.$db});
	$tables = join(" ", map { quotemeta($_) } @tables);

	&execute_before($db, STDOUT, 0, $file, $all ? undef : $db);
	unlink($file);
	$out = &backquote_logged("$config{'mysqldump'} $authstr $drop $where $quoting ".quotemeta($db)." $tables 2>&1 >$file");
	if ($? || $out) {
		print "Backup of database $db to file $file failed:\n";
		print $out;
		$ex = 1;
		}
	&execute_after($db, STDOUT, 0, $file, $all ? undef : $db);
	}
exit($ex);

