#Draw a table over the different groups
sub netgroup_list {

   my $output = qq~
  <table width="500" border="0" class="ng">
    <tr> 
      <td> <table width="100%" border="0" class="ng">
          <tr> 
            <td><table width="100%" border="0" cellspacing="0" class="ng">
            <form action="$ENV{SCRIPT_NAME}" method=post>
            <input type="hidden" name="rmnetgroup" value=1>
                <tr class="header"> 
                  <td width="20">&nbsp;</td>
                  <td width="76">$text{group}</td>
                  <td width="161">$text{numberofhosts}</td>
                  <td width="172">$text{numberofgroups}</td>
                </tr>
   ~;

    if(keys %{ $struct->{netgroups} }) {
       my $x = 0;
       foreach my $netgroupname (sort keys %{ $struct->{netgroups} }) {

		my $Netgroup = $struct->{netgroups}->{$netgroupname};

		next if($Netgroup->{deleted});

		$numberofhosts = keys %{$Netgroup->{hosts}};
		$numberofgroups = keys %{$Netgroup->{membergroups}};

		my $style = ($x % 2) ? 'nc1' : 'nc2';

		$output .= qq~
                <tr class="$style" onMouseOver="mOvr(this);return true;" onMouseOut="mOut(this);"> 
                  <td width="20"> <input type="checkbox" name="delete" value="$netgroupname"></td>
                  <td onClick="location.href='?group=$netgroupname&edit=1';return true;" ><a href="?group=$netgroupname&edit=1">$netgroupname</a></td>
                  <td onClick="location.href='?group=$netgroupname&edit=1';return true;" >$numberofhosts</td>
                  <td onClick="location.href='?group=$netgroupname&edit=1';return true;" >$numberofgroups</td>
                </tr>
		~;
	$x++;
	}
   } else {
      $output .= "<tr><td colspan=3 align=\"center\">$text{nogroups}</td></tr>";
   }

   $output .= qq~
              </table></td>
          </tr>
          <tr> 
            <td><div align="center"> 
                <input type="submit" value="$text{delete_selected_groups}">
		</form>
              </div></td>
          </tr>
        </table> </td>
    </tr>
    <tr> 
      <td><div align="center"> 
          <table width="100%" border="0" class="ng">
            <tr> 
              <td><div align="center">$text{newgroup}</div></td>
            </tr>
            <tr> 
              <td><div align="center"> 
                  <form action="$ENV{SCRIPT_NAME}" method=post>
                  <input type="hidden" name="create" value=1>
                  <input name="group" type="text" onFocus='this.value=""' value="$text{name}" size="20" maxlength="20">
                  <input type="submit" value="$text{submit}">
		  </form>
                </div></td>
            </tr>
          </table>
        </div></td>
    </tr>
  </table>
  <br>
  ~;

  $output .= list_queue();

 return $output;
}

sub list_queue
{
   my $output = qq~

<table width="500" border="0" class="ng">
    <tr class="header"> 
      <td colspan="2" align="center">$text{actionqueue}</td>
    </tr>
    <form action="$ENV{SCRIPT_NAME}" method=post>
    <input type="hidden" name="editqueue" value=1>

~;

   my $x = 0;

   for(@{$struct->{queue}}) {
      $x++ if($_->{action} && ! $_->{disregard});
   }

   unless($x) {
      $output .= qq~
      <tr><td colspan="2">$text{noactions}</td></tr>
      </table>
      </form>
      ~;
      return $output;
   }

   $x = 0;

   foreach my $object (@{ $struct->{queue} }) {
     
     my $action = $object->{action};

     if($object->{disregard} || ! $action) {
        $x++;
	next;
     }
     #$x++ and next if( ! $action || $object->{disregard}); #If the queue object is deleted.

     my $style = ($x % 2) ? 'nc1' : 'nc2';

     $output .= qq~<tr class="$style"><td width="20"> <input type="checkbox" name="delete" value="$x"></td>~;

     my $string;

     #Filthy. 
     if($action == ADD_NETGROUP) {
       $string = $text{add_netgroup};
       $string =~ s/\%group/$object->{netgroup}/i;
       $output .= qq~ <td width="480">$string</td></tr>~;
     } elsif($action == DELETE_NETGROUP) {
       $string = $text{delete_netgroup};
       $string =~ s/\%group/$object->{netgroup}/i;
       $output .= qq~ <td width="480">$string</td></tr>~;
     } elsif($action == ADD_SUBGROUP) {
       my $subgroups = join(", ", @{ $object->{subgroups} });
       $subgroups = substr($subgroups, 0, 30) . '...' if(length($subgroups) > 30);
       $string = $text{add_subgroup};
       $string =~ s/\%group/$object->{netgroup}/i;
       $string =~ s/\%subgroup/$subgroups/i;
       $output .= qq~ <td width="480">$string</td></tr>~;
     } elsif($action == DELETE_SUBGROUP) {
       my $subgroups = join(", ", @{ $object->{subgroups} });
       $subgroups = substr($subgroups, 0, 30) . '...' if(length($subgroups) > 30);
       $string = $text{delete_subgroup};
       $string =~ s/\%group/$object->{netgroup}/i;
       $string =~ s/\%subgroup/$subgroups/i;
       $output .= qq~ <td width="480">$string</td></tr>~;
     } elsif($action == ADD_TRIPLE) {
       my $triples = join(", ", map{ /\((.*?),(.*?),(.*?)\)/; $1 } @{ $object->{triples} });
       $triples = substr($triples, 0, 30) . '...' if(length($triples) > 30);
       $string = $text{add_triple};
       $string =~ s/\%group/$object->{netgroup}/i;
       $string =~ s/\%triple/$triples/i;
       $output .= qq~ <td width="480">$string</td></tr>~;
     } elsif($action == DELETE_TRIPLE) {
       my $triples = join(", ", map{ /\((.*?),(.*?),(.*?)\)/; $1 } @{ $object->{triples} });
       $triples = substr($triples, 0, 30) . '...' if(length($triples) > 30);
       $string = $text{delete_triple};
       $string =~ s/\%group/$object->{netgroup}/i;
       $string =~ s/\%triple/$triples/i;
       $output .= qq~ <td width="480">$string</td></tr>~;
     } else {
       next;
     }

    $x++;

   }

   $output .= qq~ 
        <tr>
      <td colspan="2"><div align="center"> 
          <p>
            <input type="submit" value="$text{delete_actions}">~ . hlink('<img src="images/help.gif" border="0">','edit_queue') . qq~
	    </form>
          </p>
          <table width="100%" border="0" class="ng">
            <tr> 
              <td><div align="center">$text{password}
                  <form action="$ENV{SCRIPT_NAME}" method=post>
                  <input type="hidden" name="execute" value=1>
                  <input type="password" name="password" size="20">
                  <input type="submit" value="$text{execute}">
		  </form>
                </div></td>
            </tr>
          </table>
        </div></td>
    </tr>
</table>
  ~;

  return $output;

}

1;
