#include <stdio.h>
#include <sys/types.h>
#include <dirent.h>
#include <string.h>
#include <stdlib.h>

#define DEBUG 0
#ifndef PATH_MAX
	#define PATH_MAX 255
#endif
#ifndef NAME_MAX
	#define NAME_MAX 255
#endif

int main(int argc, char **argv) {
	char pathname[PATH_MAX], newname[NAME_MAX], oldfilep[PATH_MAX];
	char newfilep[PATH_MAX], endung[NAME_MAX], extension[NAME_MAX];
	struct dirent *sdent, **sdentlist;
	long i, nr;
	int sdentref, j;

	printf("WavRen - interactively renames all WAVs in a given directory\n");
	if (argc > 3) {
		fprintf(stderr, "Usage: dirent [NR-TO-BEGIN-WITH] [EXTENSION]\n");
		exit(1);
	}
	if (argc < 3)
		strcpy(extension, ".wav");
	else
		sprintf(extension, ".%s", argv[2]);
	if (argc < 2)
		nr = 1;
	else
		nr = atoi(argv[1]);
	strcpy(pathname, ".");
	
	printf("Please enter new filenames, empty filename to skip a file.\n");
	
	sdentref = scandir(pathname, &sdentlist, NULL, alphasort);
	for (i=0; i<sdentref; i++) {
		sdent = sdentlist[i];
		if (strlen(sdent->d_name)>4) {
			strcpy(endung, &sdent->d_name[strlen(sdent->d_name)-strlen(extension)]);
			if (strcmp(endung,extension)==0) {
				printf("[%s] Name? ", sdent->d_name);
				fgets(newname,NAME_MAX,stdin);
				if (newname[strlen(newname)-1]=='\n')
					newname[strlen(newname)-1]='\0';
				if (strcmp(newname, "")!=0) {
					for (j=0; j<strlen(newname); j++) {
						if (newname[j]==' ') newname[j]='_';
					}
					sprintf(oldfilep, "%s/%s", pathname, sdent->d_name);
					sprintf(newfilep, "%s/%02ld-%s%s", pathname, nr++, newname, extension);
					if (DEBUG) {
						printf("%s\n%s\n", oldfilep, newfilep);
					}
					if (rename(oldfilep, newfilep)==-1) {
						fprintf(stderr, "Could not rename file.\n");
					}
				}
			} 
		}	
	}
	printf("Success.\n");
  return 0;
}

