#ifndef FILTER_H
#define FILTER_H

// Copyright (c) The University of Cincinnati.
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
// THE SOFTWARE, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: Radharamanan Radhakrishnan  ramanan@ececs.uc.edu
//          Philip A. Wilsey            phil.wilsey@uc.edu

/** The Filter abstract base class.

    The Filter abstract base class represents the abstract interface
    for all the different implementations of filters. The base class
    is templatized so that any variable type can be filtered.

*/
template <class Type>
class Filter {
public:

   /**@name Public Class Methods of Filter */
   //@{

   Filter(){};

   virtual ~Filter(){};

   virtual void reset() = 0;
   virtual void update(Type) = 0;
   virtual Type getData() = 0;

   //@} // End of Public Class Methods of Filter 
};


#endif
