#include "NegativeEventMessage.h"
#include "Event.h"
#include "DeserializerManager.h"

void 
NegativeEventMessage::serialize( SerializedInstance *serializeInto ) const {
  KernelMessage::serialize( serializeInto );
  serializeInto->addUnsigned( myEventIds.size() );
  for( unsigned int i = 0; i < myEventIds.size(); i++ ){
    serializeInto->addUnsigned( myEventIds[i].val );
  }
}


Serializable *
NegativeEventMessage::deserialize( SerializedInstance *data ){
  unsigned int source = data->getUnsigned();
  unsigned int dest = data->getUnsigned();
  unsigned int numIds = data->getUnsigned();
  vector<EventId> eventIds;
  for( unsigned int i = 0; i < numIds; i++ ){
    eventIds.push_back( numIds );
  }

  return new NegativeEventMessage( source,
				   dest,
				   eventIds );
				   
}

const string &
NegativeEventMessage::getNegativeEventMessageType(){
  static string negativeEventMessageType = "NegativeEventMessage";
  return negativeEventMessageType;
}

void 
NegativeEventMessage::registerDeserializer(){
  DeserializerManager::instance()->registerDeserializer( getNegativeEventMessageType(),
                                                         &NegativeEventMessage::deserialize );
}

