// This may look like C code, but it is really -*- C++ -*-
// 
// <copyright> 
//  
//  Copyright (c) 1995
//  Institute for Information Processing and Computer Supported New Media (IICM), 
//  Graz University of Technology, Austria. 
//  
// </copyright> 
// 
// 
// <file> 
// 
// Name:        tsockio.h
// 
// Purpose:     
// 
// Created:     11 Mar 96   Joerg Faschingbauer
// 
// Modified:    
// 
// Description: 
// 
// $Id: tsockio.h,v 1.7 1997/02/21 16:23:50 jfasch Exp $
// 
// $Log: tsockio.h,v $
// Revision 1.7  1997/02/21 16:23:50  jfasch
// egoist() implemented
//
// Revision 1.6  1997/02/12 23:13:11  jfasch
// moved from HgDcCommon
//
// Revision 1.5  1996/10/03 12:02:50  jfasch
// verbose.h and assert.h moved
//
// Revision 1.4  1996/08/06 08:18:18  jfasch
// missing forward decl.
//
// Revision 1.3  1996/08/05 16:01:42  jfasch
// possible to use local Dispatcher
//
// Revision 1.2  1996/03/28 09:51:54  jfasch
// decoupling things from Dispatcher
//
// Revision 1.1  1996/03/22 16:23:11  jfasch
// Initial revision
//
// 
// </file> 
#ifndef hg_dispatch_tsockio_h
#define hg_dispatch_tsockio_h

#include "iohandler.h"
#include "tio.h"

#include <hyperg/utils/socket.h>

class Dispatcher ;

class TransparentSocketIO : public TransparentIO, public IOHandler {
public:
   TransparentSocketIO (const SocketPtr&, Dispatcher* =nil /*default Dispatcher::instance()*/) ;
   virtual ~TransparentSocketIO() ;

   virtual void registerInput (TransparentIOHandler*) ;
   virtual void registerOutput (TransparentIOHandler*) ;

   virtual int read (char*, int) ;
   virtual int write (const char*, int) ;

private:
   // called by the Dispatcher when something happens on my socket
   virtual int inputReady (int) ;
   virtual int outputReady (int) ;

   virtual void egoist (bool) ;

private:
   SocketPtr socket_ ;
   Dispatcher* dispatcher_ ;

public:
   static const char* version4 ;
} ;
static const char* TransparentSocketIO_version = TransparentSocketIO::version4 ;


#endif
