/* ==================================================== ======== ======= *
 *
 *  ucontext.hpp
 *  Ubit Project  [Elc][2003]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2003 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:03] ======= *
 * ==================================================== ======== ======= */

#ifndef _ucontext_hpp_
#define	_ucontext_hpp_
//pragma ident	"@(#)ucontext.hpp	ubit:03.06.03"
#include <ubit/ufont.hpp>
#include <ubit/uborder.hpp>


//package_private: ====[internal implementation]===========================
//NOTE: this header is reserved to Ubit intrinsics

struct ULocalProps {
  char valign, halign;
  u_dim width, height;
  u_pos xpos, ypos;

  // for alpha blending
  float alpha;
  //short layer; not used

  // horizontal and vertical spacing between included items
  short vspacing, hspacing;

  // space beween content and border (if any)
  UMargins padding;

  class UBorder* border; 

  // if this group is not null the object it contains are added 
  // to children for normal display (this feature can for instance be used 
  // for adding list-item markers, checkbox markers, etc.
  class UGroup* content;	//NB: = null in most cases

  // shape of the component
  class UShape* shape;		//NB: = null in most cases

  // image or color background of the component
  const class UBackground* background;

  // used if the component is editable
  class UEdit* edit;

  void rescale(float xyscale);
};

/* ==================================================== ======== ======= */
// UContext =  a subcontext (not the first layer of the context cstack)
// and a base for UWinContext (the first layer of the cstack)
 
class UContext {
public:
  class UGroup* obj;
  class UBox*   parent_box;
  class UView * winview;
  ULocalProps   local;

  // current Colors, Font descriptor and Cursor
  const class UColor  *color, *bgcolor;
  const class UCursor *cursor;
  class UFontDesc fontdesc;

  // curent LOGICAL scale level (NB: the scale can be > 0 or < 0)
  short lscale;
  float xyscale;
  
  // true if the object is Horizontally or Vertically Flexible
  bool boxIsHFlex, boxIsVFlex;

  // number of valid flagdefs for this stack level
  // (only the first flagdefCard elements are valid for this level)
  // the flag vector is shared by all stacked Contexts

  unsigned short flagdefCount;
  const class UFlagdef ***pflagdefs;

  // creates a subcontext (not the first layer of the context stack)
  UContext(UGroup*, UView* box_view, const UContext& parent_context);
  UContext() {}

  void rescale();

  void addFlagdef(const class UFlagdef*);

  const class UFlagdef* getFlagdef(const class UFlag&) const;
  const class UFlagdef* getFlagdef(const class UFlag*) const;

  const class UPropdef* getPropdef(const class UFlag&) const;
  const class UPropdef* getPropdef(const class UFlag*) const;
};

/* ==================================================== ======== ======= */
// UWinContext = the first layer of the context cstack

class UWinContext : public UContext {
public:
  // references for pflags in subcontexts
  const class UFlagdef **flagdefs;

  // creates the first layer of the context stack
  // -- !Warning: 'win_view' must be a valid (NOT null) window view!
  UWinContext(UView* win_view);
  UWinContext(){}
  ~UWinContext();

  // this method recopies the internal flag array
  void copy(UWinContext&);
};


#endif
/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:03] ======= */
