#include "UniversalLongLongIntegerTest.hh"
#include "tyvis/UniversalLongLongInteger.hh"
#include <warped/SerializedInstance.h>
#include <warped/warped.h>
#include <clutils/StringUtilities.h>

long long
UniversalLongLongIntegerTest::getDefaultValue(){
  static long long int defaultValue = warped64Max;
  return defaultValue;
}

void 
UniversalLongLongIntegerTest::setUp(){
  toTest = new UniversalLongLongInteger( getDefaultValue() );
}

void 
UniversalLongLongIntegerTest::tearDown(){
  delete toTest;
}

void
UniversalLongLongIntegerTest::testGetUniversalKind(){
  CPPUNIT_ASSERT( toTest->getUniversalKind() == VHDLData::UNIVERSAL_LONG_LONG_INTEGER );
}

void
UniversalLongLongIntegerTest::testGetLength(){
  CPPUNIT_ASSERT( toTest->length() == 1 );
}

void
UniversalLongLongIntegerTest::testPrint(){
  UniversalLongLongInteger u( 10 );
  ostringstream printStream;
  u.print( printStream );
  CPPUNIT_ASSERT( printStream.str() == "10" );
}

void
UniversalLongLongIntegerTest::testEqual(){
  UniversalLongLongInteger a(10);
  UniversalLongLongInteger b(10);
  
  CPPUNIT_ASSERT( a == b );
}

void
UniversalLongLongIntegerTest::testNotEqual(){
  UniversalLongLongInteger a(10);
  UniversalLongLongInteger b(11);
  
  CPPUNIT_ASSERT( a != b );
}

void
UniversalLongLongIntegerTest::testGreater(){
  UniversalLongLongInteger a(10);
  UniversalLongLongInteger b(11);
  
  CPPUNIT_ASSERT( b > a );
}

void
UniversalLongLongIntegerTest::testGreaterEqual(){
  UniversalLongLongInteger a(10);
  UniversalLongLongInteger b(11);
  UniversalLongLongInteger c(11);
  
  CPPUNIT_ASSERT( b >= a );
  CPPUNIT_ASSERT( b >= c );
}

void
UniversalLongLongIntegerTest::testLess(){
  UniversalLongLongInteger a(10);
  UniversalLongLongInteger b(11);
  
  CPPUNIT_ASSERT( a < b );
}

void
UniversalLongLongIntegerTest::testLessEqual(){
  UniversalLongLongInteger a(10);
  UniversalLongLongInteger b(11);
  UniversalLongLongInteger c(11);
  
  CPPUNIT_ASSERT( a <= c );
  CPPUNIT_ASSERT( b <= c );
}

void
UniversalLongLongIntegerTest::testClone(){
  UniversalLongLongInteger *cloned = dynamic_cast<UniversalLongLongInteger *>(toTest->clone());
  CPPUNIT_ASSERT( cloned != 0 );
  CPPUNIT_ASSERT( cloned != toTest );
  CPPUNIT_ASSERT( *cloned = *toTest );
  delete cloned;
}

void
UniversalLongLongIntegerTest::testSerialization(){
  SerializedInstance *serialized = static_cast<Serializable *>(toTest)->serialize();
  CPPUNIT_ASSERT( serialized->getDataType() == toTest->getDataType() );
  UniversalLongLongInteger *deserialized = dynamic_cast<UniversalLongLongInteger *>( serialized->deserialize() );
  CPPUNIT_ASSERT( deserialized != 0 );
  CPPUNIT_ASSERT( deserialized != toTest );
  CPPUNIT_ASSERT( *deserialized = *toTest );
  delete deserialized;
}
