#include "UniversalCharacterTest.hh"
#include "tyvis/UniversalCharacter.hh"
#include <warped/SerializedInstance.h>
#include <clutils/StringUtilities.h>

char
UniversalCharacterTest::getDefaultValue(){
  static char defaultValue = 'x';
  return defaultValue;
}

void 
UniversalCharacterTest::setUp(){
  toTest = new UniversalCharacter( getDefaultValue() );
}

void 
UniversalCharacterTest::tearDown(){
  delete toTest;
}

void
UniversalCharacterTest::testGetUniversalKind(){
  CPPUNIT_ASSERT( toTest->getUniversalKind() == VHDLData::UNIVERSAL_CHARACTER );
}

void
UniversalCharacterTest::testGetLength(){
  CPPUNIT_ASSERT( toTest->length() == 1 );
}

void
UniversalCharacterTest::testPrint(){
  ostringstream printStream;
  toTest->print( printStream );
  CPPUNIT_ASSERT( "x" == printStream.str() );
}

void
UniversalCharacterTest::testEqual(){
  UniversalCharacter a( 'x' );
  UniversalCharacter b( 'x' );
  
  CPPUNIT_ASSERT( a == b );
}

void
UniversalCharacterTest::testNotEqual(){
  UniversalCharacter a( 'x' );
  UniversalCharacter b( 'v' );
  
  CPPUNIT_ASSERT( a != b );
}

void
UniversalCharacterTest::testGreater(){
  UniversalCharacter a( 'v' );
  UniversalCharacter b( 'x' );
  
  CPPUNIT_ASSERT( b > a );
}

void
UniversalCharacterTest::testGreaterEqual(){
  UniversalCharacter a( 'v' );
  UniversalCharacter b( 'x' );
  UniversalCharacter c( 'x' );
  
  CPPUNIT_ASSERT( b >= a );
  CPPUNIT_ASSERT( b >= c );
}

void
UniversalCharacterTest::testLess(){
  UniversalCharacter a( 'v' );
  UniversalCharacter b( 'x' );
  
  CPPUNIT_ASSERT( a < b );
}

void
UniversalCharacterTest::testLessEqual(){
  UniversalCharacter a( 'v' );
  UniversalCharacter b( 'x' );
  UniversalCharacter c( 'x' );
  
  CPPUNIT_ASSERT( a <= c );
  CPPUNIT_ASSERT( b <= c );
}

void
UniversalCharacterTest::testClone(){
  UniversalCharacter *cloned = dynamic_cast<UniversalCharacter *>(toTest->clone());
  CPPUNIT_ASSERT( cloned != 0 );
  CPPUNIT_ASSERT( cloned != toTest );
  CPPUNIT_ASSERT( *cloned = *toTest );
  delete cloned;
}

void
UniversalCharacterTest::testSerialization(){
  SerializedInstance *serialized = static_cast<Serializable *>(toTest)->serialize();
  CPPUNIT_ASSERT( serialized->getDataType() == toTest->getDataType() );
  UniversalCharacter *deserialized = dynamic_cast<UniversalCharacter *>( serialized->deserialize() );
  CPPUNIT_ASSERT( deserialized != 0 );
  CPPUNIT_ASSERT( deserialized != toTest );
  CPPUNIT_ASSERT( *deserialized = *toTest );
  delete deserialized;
}
