//---------------------------------------------------------------------------
// Copyright (c) 1995-1999 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

//---------------------------------------------------------------------------

#ifndef STD_STANDARDPKG_HH
#define STD_STANDARDPKG_HH

#include "tyvis/IntegerType.hh"
#include "tyvis/RealType.hh"
#include "tyvis/EnumerationType.hh"
#include "tyvis/PhysicalType.hh"
#include "tyvis/AccessType.hh"
#include "tyvis/FileType.hh"
#include "tyvis/RecordType.hh"

extern EnumerationTypeInfo  SavantbitType_info;
extern EnumerationTypeInfo  SavantcharacterType_info;
extern EnumerationTypeInfo  SavantbooleanType_info;
extern EnumerationTypeInfo  Savantseverity_levelType_info;
extern EnumerationTypeInfo  Savantfile_open_kindType_info;
extern EnumerationTypeInfo  Savantfile_open_statusType_info;

extern IntegerTypeInfo SavantintegerType_info;
extern IntegerTypeInfo SavantnaturalType_info;
extern IntegerTypeInfo SavantpositiveType_info;
extern IntegerTypeInfo SavantwidthType_info;

extern RealTypeInfo  SavantrealType_info;

extern PhysicalTypeInfo   SavanttimeType_info;
extern PhysicalTypeInfo   Savantdelay_lengthType_info;

extern ArrayTypeInfo    Savantbit_vectorType_info;
extern ArrayTypeInfo    Savantbit_vectorType_event_info;
extern ArrayTypeInfo    Savantbit_vectorType_lastevent_info;

extern ArrayTypeInfo    SavantstringType_info;
extern ArrayTypeInfo    SavantstringType_event_info;
extern ArrayTypeInfo    SavantstringType_lastevent_info;

#define SAVANT_BOOLEAN_TRUE EnumerationType::getEnumerationTrue()
#define SAVANT_BOOLEAN_FALSE EnumerationType::getEnumerationFalse()

extern const PhysicalType    SAVANT_ZERO_TIME;
extern const PhysicalType    SAVANT_INFINITY_TIME;

extern const EnumerationTypeInfo        NULL_ENUM_INFO;

extern const AccessTypeInfo SavantaccessType_info;

#ifndef savantnow
#define savantnow (PhysicalType(ObjectBase::VARIABLE, UniversalLongLongInteger(getTimeNow().time)), SavanttypeTime_info)
#endif

#endif

