#ifndef SCALARTYPE_HH
#define SCALARTYPE_HH

/** Copyright (c) 1995-1996 Ohio Board of Regents and the University of
 Cincinnati.  All Rights Reserved.

 You may modify, distribute, and use the software contained in this
 package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
 version 2, June 1991. A copy of this license agreement can be found in
 the file "LGPL", distributed with this archive.  */

#include "tyvis/ObjectBase.hh"
#include "tyvis/VHDLType.hh"
#include "tyvis/TypeInfo.hh"
#include "tyvis/UniversalInteger.hh"

enum ArrayInfo::ArrayDirn_t;
class VHDLProcess;

class ScalarType : public VHDLType {
public:
  ScalarType() : VHDLType(), object(0) {}
  ScalarType(ObjectBase::ObjectType, bool alias = false);
  ScalarType(const ScalarType&);

  virtual ~ScalarType();

  bool is_scalar_type() const { return true; }

  virtual void print(ostream& os) const;

  /** Remember to delete the return char* in the place where it is
      used. */
  virtual char* getString() const;

  /** This method just returns 1.  It is required in concatenation
      operator, while concatenating a scalar type and a scalar type to get
      an array type. */
  int left() const;

  ArrayInfo::ArrayDirn_t dirn() const;
  int right() const;
  void increment();
  void decrement();

  VHDLType& operator =(const VHDLType& val);
  virtual ScalarType& operator =(const ScalarType& val);
  VHDLType& assignVal(const VHDLType& val);

  bool operator==( const RValue & ) const;
  bool operator!=( const RValue & ) const;
  bool operator<( const RValue & ) const;
  bool operator<=( const RValue & ) const;
  bool operator>( const RValue & ) const;
  bool operator>=( const RValue & ) const;

  virtual ObjectBase::ObjectType getKind() const;

  virtual VHDLType* clone() const;

  int savantwrite( AccessVariable &line ) const;
  int savantwrite( AccessType& line) const;
  int savantread( AccessVariable &line );
  int savantread( AccessType& line);

  /** The TYPE's resolve is called only for composite resolved signals
      This resolve goes down to first sub-element of the VHDLType and
      calls the sub-elements resolve, but which actually does the
      resolution for the whole composite type */
  virtual VHDLType *resolve( VHDLKernel * );
  virtual void updateEffVal(const VHDLType*);
  virtual void setResolutionFunctionId(int resolutionFnId);
  virtual void setTypeConversionFunctionId(int typeConversionFnId);

  virtual void setParentCompositeType(VHDLType*);
  virtual void setCompositeResolvedSignal(bool);
  void setElaborationInfo(const VHDLType&);
  void setAttrib(AttribType, VHDLType&);
  void initializeImplicitSignal(AttribType);

  virtual const VHDLData& leftValue();
  virtual bool _is_signal() const { return object->_is_signal(); }

  virtual bool overflow() const;
  virtual SignalBase* locateSig(int);
  virtual SignalBase* findSigInBlock(int, VHDLProcess *);
  void setBusKind();

  virtual void Add( const VHDLType & );
  virtual void Add( const SignalNetinfo * );
  virtual void Add( VHDLProcess *processPtr, int sigid );

  virtual void copyId( const VHDLType &src );

  virtual int get_number_of_elements(int dimension = 0) const { (void)dimension; return 1; }
  virtual void dump_connectivity_info(ofstream&);

  ObjectBase *getObject() const { return object; }
  void setObject( ObjectBase *newObj ){ object = newObj; }

private:
  /** Pointer to the type of the object */
  ObjectBase* object;

};


extern UniversalInteger getIndex(const char* ptr, char** imageMap, int);
extern ostream& operator<<(ostream &, const ScalarType &);

#endif

