//---------------------------------------------------------------------------
// Copyright (c) 2001-2003 Clifton Labs, Inc.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

#ifndef FOREIGN_PROCESS_HH
#define FOREIGN_PROCESS_HH

#include "tyvis/VHDLProcess.hh"
#include <string>

using std::string;
class _savant_entity_elab;

class ForeignProcess : public VHDLProcess {
public:
  /**
     This method takes a .so filename as a parameter and loads a module
     using it.  This is the only intended method of instantiating a foreign
     process.
  */
  static ForeignProcess *instantiate( const string &so_file,
				      const string &processName, 
				      _savant_entity_elab *initElabObj );
  
  /**
     Destructor
  */
  virtual ~ForeignProcess() = 0;

  /**
     Initialization hook.
  */
  virtual void initialize() = 0;

  void createNetInfo();

protected:
  /**
     Constructor
  */
  ForeignProcess( const string &processName, 
		  _savant_entity_elab *initElabObj );
  
private:
  const string myProcessName;
};

#endif
