#include "ForeignProcess.hh"
#include "ForeignProcessFactory.hh"
#include <clutils/PluginManager.h>
#include <clutils/Debug.h>

ForeignProcess::ForeignProcess( const string &processName, 
				_savant_entity_elab *initElabObj ) :
  VHDLProcess( processName, initElabObj ){
  clutils::debug << "ForeignProcess::ForeignProcess( " << processName << ", " 
		 << initElabObj << " ) called" << endl;
}

ForeignProcess::~ForeignProcess(){}

ForeignProcess * 
ForeignProcess::instantiate( const string &soFile, 
			     const string &processName, 
			     _savant_entity_elab *owner ){
  clutils::debug << "ForeignProcess::instantiate called!" << endl;

  ForeignProcess *retval = 0;
  PluginBase *module = PluginManager::instance()->loadPlugin( soFile );
  if( module == 0 ){
    cerr << "Error loading module from " << soFile << ":" 
	 << PluginManager::instance()->getLastError() << endl;
  }
  else{
    // Now we have a factory, which we can use to instiate the real thing.
    ForeignProcessFactory *factory = static_cast<ForeignProcessFactory *>( module ); 
    retval = factory->createProcess( processName, owner );
  }

  return retval;
}

void
ForeignProcess::createNetInfo(){
  cerr << "ForeignProcess::createNetInfo() called!" << endl;
  abort();
}
