#include "Types.hh"
#include "AccessType.hh"
#include "std_standardPkg.hh"

Block AccessType::accessedObjectList;

int savantdeallocate( VHDLKernel *, AccessType& ptr ){
  ptr.deallocate();
  return NORMAL_RETURN;
}

AccessType::AccessType(bool alias, const AccessType& actual) 
  :VHDLType(alias) {
  setPointer(actual.getPointer());
}

AccessType::AccessType(const AccessType &src) : VHDLType(true) {
  setPointer(src.getPointer());
}

AccessType::AccessType(const VHDLType &src) {
  if (src.get_kind() == ACCESS_TYPE) {
    is_alias = true;
    setPointer(((const AccessType &) src).getPointer());
  }
  else {
    setPointer(NULL);
  }
}

AccessType::AccessType(VHDLType &src) {
  if (src.get_kind() == ACCESS_TYPE) {
    is_alias = true;
    setPointer(((const AccessType &) src).getPointer());
  }
  else {
    setPointer(&src);
  }
}

AccessType::AccessType(VHDLType *src) {
  setPointer(src);
}

void
AccessType::addValueToListForDeletion() {
  if (getPointer() != NULL)
    accessedObjectList.addElement(getPointer());
  setPointer(NULL);
}

VHDLType& 
AccessType::all() {
  ASSERT ( val != NULL );
  return (*val);
}

ObjectBase::ObjectType
AccessType::getKind() const {
  ASSERT ( val != NULL );
  return val->getKind();
}

VHDLType&
AccessType::operator=(const VHDLType& val) {
  if (val.get_kind() == ACCESS_TYPE) {
    setPointer(((const AccessType &) val).getPointer());
  }

  return *this;
}

AccessType&
AccessType::operator=(const AccessType& val) {
  setPointer(val.getPointer());

  return *this;
}

VHDLType&
AccessType::operator=(VHDLType* val) {
  setPointer(val);

  return *this;
}

VHDLType&
AccessType::operator[](const ScalarType &rhs) const {
  ASSERT ( val != NULL );

  return val->operator[](rhs);
}

VHDLType&
AccessType::operator[](const int index) const {
  ASSERT ( val != NULL );

  return val->operator[](index);
}

bool
AccessType::operator==( const RValue &val ) const {
  bool retval = false;

  VHDLType *lhs_pointer = getPointer();
  VHDLType *rhs_pointer = dynamic_cast<const AccessType &>(val).getPointer();
  
  if( lhs_pointer ){
    if( rhs_pointer ){
      retval = lhs_pointer->operator==( *rhs_pointer );
    }
  }
  else if( !rhs_pointer ){
    retval = true;
  }

  return retval;
}

bool
AccessType::operator!=( const RValue &val ) const {
  return !(operator==(val));
}
bool
AccessType::operator<( const RValue & ) const {
  abort();
}
bool
AccessType::operator<=( const RValue & ) const {
  abort();
}
bool
AccessType::operator>( const RValue & ) const {
  abort();
}
bool
AccessType::operator>=( const RValue & ) const {
  abort();
}

void
AccessType::deallocate() {
  if(getPointer() != NULL) {
    delete getPointer();
    resetPointer();
  }
}

void
AccessType::setPointer(VHDLType* src) {
  val = NULL;
  
  if (src != NULL) {
    if (src->get_kind() == ACCESS_TYPE) {
      val = ((AccessType *) src)->val;
    }
    else {
      val = src;
    }
  }
}

VHDLType*
AccessType::getPointer() const {
  return val;
}

void
AccessType::resetPointer() {
  val = NULL;
}

Type
AccessType::get_kind() const {
  return ACCESS_TYPE;
}

void
AccessType::print(ostream& os) const {
  os << val << " (";
  val->print(os);
  os << ")\n";
}

ObjectBase*
AccessType::getObject() const {
  cerr << "ERROR: AccessType::getObject() called " << endl;    
  return NULL;
}

VHDLType* 
AccessType::clone() const {
  return new AccessType(val->clone());
}

// EnumerationType
// savantEqual(const AccessType& lhs, const AccessType& rhs) {
//   if(lhs.getPointer() != rhs.getPointer()){
//     return SAVANT_BOOLEAN_FALSE;
//   }
//   else{
//     return SAVANT_BOOLEAN_TRUE;
//   }
// }

// EnumerationType 
// savantNotEqual(const AccessType& lhs, const AccessType& rhs) {
//   if(lhs.getPointer() != rhs.getPointer()) {
//     return SAVANT_BOOLEAN_TRUE;
//   } else {
//     return SAVANT_BOOLEAN_FALSE;
//   }
// }

ostream&
operator<<(ostream& os, const AccessType &at) {
  if (at.getPointer() != NULL) {
    os << *(at.getPointer());
  }

  return os;
}
