# $Id: version.tcl,v 1.7 2003/12/28 21:38:50 aleksey Exp $

custom::defvar options(reply_iq_version) 1 \
    [::msgcat::mc "Reply to version (jabber:iq:version) requests."] \
        -group IQ -type boolean

proc try_linux_version {distr file flag} {
    global linux_distribution

    if {![file exists $file]} {
	return
    }
    if {![file readable $file]} {
	set linux_distribution $distr
	return
    }
    set fd [open $file r]
    set content [read $fd]
    close $fd
    set last [string first "\n" $content]
    if {$last < 0} {
	set last end
    } else {
	set last [expr {$last - 1}]
    }
    set line [string range $content 0 $last]

    switch -- $flag {
	file { set linux_distribution $line }
	append { set linux_distribution "$distr $line" }
    }
}

proc guess_linux_distribution {} {
    global linux_distribution

    if {[info exists linux_distribution]} {
	return $linux_distribution
    }

    foreach {distr file flag} { \
	"SuSE Linux"	    /etc/SuSE-release	    file \
	"Debian GNU/Linux"  /etc/debian_version	    append \
	"ASPLinux"          /etc/asplinux-release   file \
	"Alt Linux"	    /etc/altlinux-release   file \
	"PLD Linux"         /etc/pld-release	    file \
	"Gentoo Linux"	    /etc/gentoo-release	    file \
	"Mandrake Linux"    /etc/mandrake-release   file \
	"RedHat Linux"	    /etc/redhat-release	    file \
	"Conectiva Linux"   /etc/conectiva-release  file \
	"Slackware Linux"   /etc/slackware-version  append } {

	try_linux_version $distr $file $flag

	if {[info exists linux_distribution]} {
	    return $linux_distribution
	}
    }

    set linux_distribution Linux
    return $linux_distribution
}

proc iq_version {connid from child} {
    global version toolkit_version tcl_platform
    variable options

    if {!$options(reply_iq_version)} {
	return {error cancel service-unavailable}
    }

    jlib::wrapper:splitxml $child tag vars isempty chdata children

    switch -- $tcl_platform(os) {
	Linux {
	    set os "[guess_linux_distribution] $tcl_platform(osVersion)"
	}
	default {
	    set os "$tcl_platform(os) $tcl_platform(osVersion)"
	}
    }
    
    set restags [list \
		     [jlib::wrapper:createtag name -chdata Tkabber] \
		     [jlib::wrapper:createtag version -chdata \
			  "$version ($toolkit_version)"] \
		     [jlib::wrapper:createtag os -chdata $os]]

    set res [jlib::wrapper:createtag query \
		 -vars {xmlns jabber:iq:version} \
		 -subtags $restags]
    
    return [list result $res]
}

iq::register_handler get query jabber:iq:version \
    [namespace current]::iq_version

