# $Id: draw_normal_message.tcl,v 1.8 2004/04/07 20:13:50 aleksey Exp $

proc draw_normal_message {chatid from type body x} {
    if {[chat::is_our_jid $chatid $from]} {
	set tag me
    } else {
	set tag they
    }

    set chatw [chat::chat_win $chatid]
    set nick [chat::get_nick $from $type]

    $chatw insert end "<$nick>" [list $tag NICK-$nick] " "

    $chatw mark set MSGLEFT "end - 1 char"
    $chatw mark gravity MSGLEFT left

    set cw [chat::winid $chatid]
    if {[cequal $type groupchat]} {
	set myjid [chat::our_jid $chatid]
	set mynick [chat::get_nick $myjid $type]

	lassign [check_message $mynick $body] mymessage mylist
	if {$mymessage} {
	    set win [::chat::chat_win $chatid]
	    set ind 0
	    foreach {i1 i2} $mylist {
		chat::add_emoteiconed_text $win [crange $body $ind [expr {$i1 - 1}]] ""
		$chatw insert end [crange $body $i1 [expr {$i2 - 1}]] highlight
		set ind $i2
	    }
	    chat::add_emoteiconed_text $win [crange $body $ind end] ""
	    tab_set_updated $cw 1 mesg_to_user
	} else {
	    chat::add_emoteiconed_text [::chat::chat_win $chatid] $body ""
	    tab_set_updated $cw 1 message
	}
    } else {
	chat::add_emoteiconed_text [::chat::chat_win $chatid] $body ""
	tab_set_updated $cw 1 mesg_to_user
    }

    $chatw tag add MSG-$nick MSGLEFT "end - 1 char"

    return stop
}
hook::add draw_message_hook [namespace current]::draw_normal_message 85
