/***************************************************************************
 *   copyright            : (C) 1999 by Daniel Reith                       *
 *   email                : DanR@gmx.de                                    *
 *                                                                         *
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : pingos@hendrik-sattler.de                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dirs.H"
#include "lektion.h"
#include "main.h"
#include "lektionsauswahl.h"
#include "lektionsauswertung.h"
#include "lektionsanweisung.h"
#include "ConfigFile.H"
#include "LEntry.H"

void Lektion::Init (LessonController* controller) {
  sw.Pause();
  this->con=controller;
  parent = Hauptfenster::getPtr();
  out = parent->GetOutput();
  in = parent->GetInput();
  in->SetEditable(true);
}

Lektion::Lektion (unsigned int lesson, LessonController* controller, int id)
  : lessonID(id)
{
  Init(controller);
  if (!LektionLaden(lesson)) {
    throw LessonLoadedFailed();
  }
}

Lektion::Lektion(UrlFile& lesson, LessonController* controller, int id)
  : lessonID(id)
{
  Init(controller);
  if (!LektionLaden(lesson)) {
    throw LessonLoadedFailed();
  }
}

Lektion::~Lektion () {
  sw.Pause();
  wxTimer::Stop();
  parent->GetFileMenu()->Enable(D_LPause, false);

  in->Clear();
  out->Clear();

  /* change the status bars
   */
  const int fields = 1;
  int i[fields]={-1};
  parent->GetStatusBar()->SetFieldsCount(1,i);
  parent->SetStatusText(_("No lesson loaded"));
}

/* Load lesson
 */
bool Lektion::LektionLaden (unsigned int index) {
  if (index == 0) {
    return false;
  }
  LessonPath f;
  f.appendDir(TtConfigFile::getPtr()->getKeyboardLayout());
  f.setFileName(_T("lektion"));
  wxString filename;
  filename << index;
  f.setFileExt(filename);

  return LektionLaden(f);
}
bool Lektion::LektionLaden (UrlFile& lesson) {
  in->Clear();
  out->Clear();
  this->line=0;
  this->charpos = 0;
  m_fehler = 0;
  m_richtig = 0;
  markedCorrect=true;
  this->con->pushStartEvent(this->lessonID);
  bool loaded = fillCache(lesson);
  parent->GetFileMenu()->Enable(D_LPause, loaded);
  parent->GetFileMenu()->Enable(D_LektionBeenden, loaded);
  const int fields = 5;
  int i[fields]={-1, 150, 100, 100, 100};
  parent->GetStatusBar()->SetFieldsCount(fields,i);
  updateStatusbar(_T(""),0,0);
  if (loaded) {
    outputFromCache(out,out->getSpecialLineEnd());
    markNextChar(0,0);
    sw.Start(0);
    wxTimer::Start(1000);    
    in->SetFocus();
  }
  return loaded;
}

#include "commonElements.H"
bool Lektion::fillCache (UrlFile& lesson) {
  bool retval = true;

  wxURL* u = lesson.getURL();
  wxInputStream* stream = common::getInputStream(*u);
  if (stream == 0) {
    ::wxLogError(_("Cannot load file %s"), lesson.getFullFileName().c_str());
    retval = false;
  } else {
    //filling cache
    this->cache= common::getIndexFile(*stream,lesson.getCharset());
  }
  delete stream;
  delete u;
  return retval;
}

void Lektion::outputFromCache(wxTextCtrl* output, wxUChar specialLineEnd) {
  if (output == 0) {
    return;
  }

  wxString end;
  if (specialLineEnd != 0) {
    end << (wxChar)specialLineEnd;
  }
  end << _T('\n');
  wxString content;
  for (unsigned int i=0;i<cache.GetCount();++i) {
    content += cache[i] + end;
  }
  output->Freeze();
  output->Clear();
  output->AppendText(content);
  output->Thaw();
}

wxUChar Lektion::getCharFromCache (unsigned int row, unsigned int column) {
  if (column < this->cache[row].Len()) {
    return wxUChar(this->cache[row].GetChar(column));
  } else {
    return wxUChar(_T('\n'));
  }
}

void Lektion::markNextChar (unsigned int row, unsigned int column) {
  if (row == 0 && column == 0) {
    out->highlightFirstChar();
  } else {
    out->highlightNextChar(1,(column==0));
  }
  wxString s;
  if (column >= this->cache[row].Len()) {
    s = _("return key");
  } else {
    switch(this->cache[row].GetChar(column)) {
    case ' ':
      s = _("space key");
      break;
    case '\t':
      s = _("tabulator key");
      break;
    default:
      s = this->cache[row].GetChar(column);
      break;
    }
  }
  parent->SetStatusText(s,1);
}

#include <algorithm>
#ifndef __VISUALC__
  using std::min;
  using std::max;
#endif
long Lektion::getCurrentPos () {
  long retval = 0;
  //first add all characters from all rows
  for (unsigned int i=0; i<line; ++i) {
    retval += this->cache[i].Len();
  }
  retval += charpos;
  
  //now treat the special line end characters correctly
  retval += line; //adds all '\n'
  if (out->getSpecialLineEnd() != 0) {
    retval += line; //adds all special line end chars
  }
  return retval;
}

/* checkInput(int c)
 * this compares the input and counts correct and false input
 */
bool Lektion::checkInput (int c) {
  wxUChar keycode = (wxUChar) c;
  wxUChar d = getCharFromCache(this->line,this->charpos);
  if (d == keycode) {
    //position update on output control
    if (d == '\n') {
      ++this->line;
      this->charpos=0; //zero based
    } else {
      ++this->charpos;
    }

    //update number for status bar
    if (markedCorrect) {
      in->setBgColor(new wxColor(wxSystemSettings::GetColour(wxSYS_COLOUR_WINDOW)));
      in->updateLook();
      ++m_richtig;
    } else {
      markedCorrect=true;
    }
  } else {
    if (markedCorrect) {
      in->setBgColor(wxRED);
      in->updateLook();
      ++m_fehler;
      markedCorrect=false;
    }
  }
  wxString s2;
  if (markedCorrect) {
    in->appendChar(d);
    if (this->line >= this->cache.GetCount()) {
      parent->SetStatusText(_("Lesson finished"));
      parent->SetStatusText(_T(""),1);
      LektionEnde();
    } else {
      markNextChar(this->line,this->charpos);
    }
    s2 = _("Correct");
  } else {
    if (TtConfigFile::getPtr()->getBellStatus()) {
      wxBell();
    }
    s2 = _("Wrong");
  }
  updateStatusbar(s2,this->m_fehler,this->m_richtig);
  return markedCorrect;
}

/* Ich brauch ne Pause
 */
void Lektion::Pause () {
  if (this->con->runningLesson()) {
    sw.Pause();
    wxMessageBox(_("Press \"OK\" to continue..."), 
		 _("Lesson paused"), wxOK, parent);
    sw.Resume();
  }
}

/* Ende der Lektion erreicht, was passiert jetzt?
 */
void Lektion::LektionEnde () {
  sw.Pause();
  in->SetEditable(false);
  this->con->pushFinishEvent(this->lessonID);
}

/* Lektion abbrechen
 */
void Lektion::LektionAbbrechen () {
  sw.Pause();
  in->SetEditable(false);
  this->con->pushAbortEvent(this->lessonID);
}

/*  Lektionsanweisung anzeigen
 */
void Lektion::Lektionsanweisung (unsigned int index) {
  wxString s;
  s << _("Lesson ") << index;
  LessonStartDlg la(parent, index, _T(""), -1, s);
  la.Centre();
  la.ShowModal();
}

void Lektion::updateStatusbar(const wxString& generic, long wrong, long correct) {
  parent->SetStatusText(generic,0);
  wxString s2;
  s2 << _("Wrong") << _T(": ") << wrong;
  parent->SetStatusText(s2, 2);
  s2.Empty();
  s2 << _("Correct") << _T(": ") << correct;
  parent->SetStatusText(s2, 3);
}

/* called by wxTimer: update time counter status bar display
 */
void Lektion::Notify () {
  parent->SetStatusText(GetLessonData().getZeitString(), 4);
}
