/* -*- mode: c; c-file-style: "gnu" -*-
 * stats.h -- server statistics, prototypes
 * Copyright (C) 2003, 2004 Gergely Nagy <algernon@bonehunter.rulez.org>
 *
 * This file is part of Thy.
 *
 * Thy is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 dated June, 1991.
 *
 * Thy is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/** @file stats.h
 * Server statistics -- prototypes.
 */

#ifndef _THY_STATS_H
#define _THY_STATS_H 1 /**< stats.h multi-inclusion guard. */

#include <stddef.h>

void thy_stats_requests_inc (int v);
void thy_stats_transfer_inc (size_t size);
void thy_stats_start (void);

size_t thy_stats_transfers (void);
long int thy_stats_requests (void);
int thy_stats_uptime (void);

#endif /* !_THY_STATS_H */
